package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class TokenAbstract extends BusinessEntityWikitty implements Token {

    private static final long serialVersionUID = -894068414L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionToken =
        new WikittyExtension(EXT_TOKEN, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String token",
				"String email"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionToken);

        extensions = Collections.unmodifiableList(exts);
    }

	public TokenAbstract() {
		super();
	}

    public TokenAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public TokenAbstract(Wikitty wi) {
		super(wi);
	}


    public void setToken(String token) {
        Object oldValue = getField(EXT_TOKEN, "token");
        getWikitty().setField(EXT_TOKEN, "token", token);
        getPropertyChangeSupport().firePropertyChange("token", oldValue, token);
    }

    public String getToken() {
        String result = getWikitty().getFieldAsString(EXT_TOKEN, "token");
        return result;
    }


    public void setEmail(String email) {
        Object oldValue = getField(EXT_TOKEN, "email");
        getWikitty().setField(EXT_TOKEN, "email", email);
        getPropertyChangeSupport().firePropertyChange("email", oldValue, email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_TOKEN, "email");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TOKEN, FIELD_TOKEN);
            Object f2 = w2.getFieldAsObject(EXT_TOKEN, FIELD_TOKEN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TOKEN, FIELD_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_TOKEN, FIELD_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //TokenAbstract
