/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 *
 * @author bbrossaud
 */
public class AliasServlet extends HttpServlet {

    protected String bowServletUrl = "";

    public AliasServlet() throws ArgumentsParserException {
        BowConfig config = BowConfig.getInstance();
        bowServletUrl = config.getBowUrl() + config.getServletBow() ;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException {
        this.doPost(request, response);
    }

    /* @param request              servlet request
     * @param response             servlet response
     * @throws ServletException    if a servlet error occurs
     */
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException {
        try {
            String alias = request.getPathInfo();
            if (alias != null && !alias.isEmpty()) {
                // remove first '/'
                alias = alias.substring(1);
                WikittyProxy proxy = BowProxy.getInstance();
                Criteria criteria = Search.query().eq(Bookmark.FQ_FIELD_ALIAS, alias).criteria();
                Bookmark bookmark = proxy.findByCriteria(Bookmark.class, criteria);
                if (bookmark != null) {
                    String redirect = bookmark.getLink();
                    response.sendRedirect(redirect);
                } else {
                    response.sendRedirect(bowServletUrl);
                }
            } else {
                response.sendRedirect(bowServletUrl);
            }
        } catch (Exception eee) {
            request.getRequestDispatcher("error.jsp").forward(request, response);
        }
    }
}
