// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.libfreenect2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.libfreenect2.global.freenect2.*;


/** \defgroup device Initialization and Device Control
 * Find, open, and control Kinect v2 devices. */
/**\{
<p>
/** Device control. */
@Namespace("libfreenect2") @Properties(inherit = org.bytedeco.libfreenect2.presets.freenect2.class)
public class Freenect2Device extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Freenect2Device(Pointer p) { super(p); }

  @MemberGetter public static native @Cast("const unsigned int") int VendorId();
  public static final int VendorId = VendorId();
  @MemberGetter public static native @Cast("const unsigned int") int ProductId();
  public static final int ProductId = ProductId();
  @MemberGetter public static native @Cast("const unsigned int") int ProductIdPreview();
  public static final int ProductIdPreview = ProductIdPreview();

  /** Color camera calibration parameters.
   * Kinect v2 includes factory preset values for these parameters. They are used in Registration.
   */
  public static class ColorCameraParams extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public ColorCameraParams() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public ColorCameraParams(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public ColorCameraParams(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public ColorCameraParams position(long position) {
          return (ColorCameraParams)super.position(position);
      }
      @Override public ColorCameraParams getPointer(long i) {
          return new ColorCameraParams((Pointer)this).offsetAddress(i);
      }
  
    /** \name Intrinsic parameters */
    /**\{ */
    /** Focal length x (pixel) */
    public native float fx(); public native ColorCameraParams fx(float setter);
    /** Focal length y (pixel) */
    public native float fy(); public native ColorCameraParams fy(float setter);
    /** Principal point x (pixel) */
    public native float cx(); public native ColorCameraParams cx(float setter);
    /** Principal point y (pixel) */
    public native float cy(); public native ColorCameraParams cy(float setter);
    /**\}
    <p>
    /** \name Extrinsic parameters
     * These parameters are used in [a formula](https://github.com/OpenKinect/libfreenect2/issues/41#issuecomment-72022111) to map coordinates in the
     * depth camera to the color camera.
     *
     * They cannot be used for matrix transformation.
     */
    /**\{ */
    public native float shift_d(); public native ColorCameraParams shift_d(float setter);
    public native float shift_m(); public native ColorCameraParams shift_m(float setter);

    public native float mx_x3y0(); public native ColorCameraParams mx_x3y0(float setter); // xxx
    public native float mx_x0y3(); public native ColorCameraParams mx_x0y3(float setter); // yyy
    public native float mx_x2y1(); public native ColorCameraParams mx_x2y1(float setter); // xxy
    public native float mx_x1y2(); public native ColorCameraParams mx_x1y2(float setter); // yyx
    public native float mx_x2y0(); public native ColorCameraParams mx_x2y0(float setter); // xx
    public native float mx_x0y2(); public native ColorCameraParams mx_x0y2(float setter); // yy
    public native float mx_x1y1(); public native ColorCameraParams mx_x1y1(float setter); // xy
    public native float mx_x1y0(); public native ColorCameraParams mx_x1y0(float setter); // x
    public native float mx_x0y1(); public native ColorCameraParams mx_x0y1(float setter); // y
    public native float mx_x0y0(); public native ColorCameraParams mx_x0y0(float setter); // 1

    public native float my_x3y0(); public native ColorCameraParams my_x3y0(float setter); // xxx
    public native float my_x0y3(); public native ColorCameraParams my_x0y3(float setter); // yyy
    public native float my_x2y1(); public native ColorCameraParams my_x2y1(float setter); // xxy
    public native float my_x1y2(); public native ColorCameraParams my_x1y2(float setter); // yyx
    public native float my_x2y0(); public native ColorCameraParams my_x2y0(float setter); // xx
    public native float my_x0y2(); public native ColorCameraParams my_x0y2(float setter); // yy
    public native float my_x1y1(); public native ColorCameraParams my_x1y1(float setter); // xy
    public native float my_x1y0(); public native ColorCameraParams my_x1y0(float setter); // x
    public native float my_x0y1(); public native ColorCameraParams my_x0y1(float setter); // y
    public native float my_x0y0(); public native ColorCameraParams my_x0y0(float setter); // 1
    /**\} */
  }

  /** IR camera intrinsic calibration parameters.
   * Kinect v2 includes factory preset values for these parameters. They are used in depth image decoding, and Registration.
   */
  public static class IrCameraParams extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public IrCameraParams() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public IrCameraParams(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public IrCameraParams(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public IrCameraParams position(long position) {
          return (IrCameraParams)super.position(position);
      }
      @Override public IrCameraParams getPointer(long i) {
          return new IrCameraParams((Pointer)this).offsetAddress(i);
      }
  
    /** Focal length x (pixel) */
    public native float fx(); public native IrCameraParams fx(float setter);
    /** Focal length y (pixel) */
    public native float fy(); public native IrCameraParams fy(float setter);
    /** Principal point x (pixel) */
    public native float cx(); public native IrCameraParams cx(float setter);
    /** Principal point y (pixel) */
    public native float cy(); public native IrCameraParams cy(float setter);
    /** Radial distortion coefficient, 1st-order */
    public native float k1(); public native IrCameraParams k1(float setter);
    /** Radial distortion coefficient, 2nd-order */
    public native float k2(); public native IrCameraParams k2(float setter);
    /** Radial distortion coefficient, 3rd-order */
    public native float k3(); public native IrCameraParams k3(float setter);
    /** Tangential distortion coefficient */
    public native float p1(); public native IrCameraParams p1(float setter);
    /** Tangential distortion coefficient */
    public native float p2(); public native IrCameraParams p2(float setter);
  }

  /** Configuration of depth processing. */
  public static class Config extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Config() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Config(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Config(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Config position(long position) {
          return (Config)super.position(position);
      }
      @Override public Config getPointer(long i) {
          return new Config((Pointer)this).offsetAddress(i);
      }
  
    /** Clip at this minimum distance (meter). */
    public native float MinDepth(); public native Config MinDepth(float setter);
    /** Clip at this maximum distance (meter). */
    public native float MaxDepth(); public native Config MaxDepth(float setter);

    /** Remove some "flying pixels". */
    public native @Cast("bool") boolean EnableBilateralFilter(); public native Config EnableBilateralFilter(boolean setter);
    /** Remove pixels on edges because ToF cameras produce noisy edges. */
    public native @Cast("bool") boolean EnableEdgeAwareFilter(); public native Config EnableEdgeAwareFilter(boolean setter);

    /** Default is 0.5, 4.5, true, true */
  }

  public native @StdString BytePointer getSerialNumber();
  public native @StdString BytePointer getFirmwareVersion();

  /** Get current color parameters.
   * \copydetails ColorCameraParams
   */
  public native @ByVal ColorCameraParams getColorCameraParams();

  /** Get current depth parameters.
   * \copydetails IrCameraParams
   */
  public native @ByVal IrCameraParams getIrCameraParams();

  /** Replace factory preset color camera parameters.
   * We do not have a clear understanding of the meaning of the parameters right now.
   * You probably want to leave it as it is.
   */
  public native void setColorCameraParams(@Const @ByRef ColorCameraParams params);

  /** Replace factory preset depth camera parameters.
   * This decides accuracy in depth images. You are recommended to provide calibrated values.
   */
  public native void setIrCameraParams(@Const @ByRef IrCameraParams params);

  /** Configure depth processing. */
  public native void setConfiguration(@Const @ByRef Config config);

  /** Provide your listener to receive color frames. */
  public native void setColorFrameListener(FrameListener rgb_frame_listener);

  /** Provide your listener to receive IR and depth frames. */
  public native void setIrAndDepthFrameListener(FrameListener ir_frame_listener);

  /** Start data processing with both RGB and depth streams.
   * All above configuration must only be called before start() or after stop().
   *
   * FrameListener will receive frames when the device is running.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean start();

  /** Start data processing with or without some streams.
   * FrameListener will receive enabled frames when the device is running.
   *
   * @param rgb Whether to enable RGB stream.
   * @param depth Whether to enable depth stream.
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean startStreams(@Cast("bool") boolean rgb, @Cast("bool") boolean depth);

  /** Stop data processing.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean stop();

  /** Shut down the device.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") @Name("close") boolean _close();
}
