/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected static byte[] copyData(AbstractTlsSecret other) {
        return other.copyData();
    }

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    @Override
    public synchronized byte[] calculateHMAC(int cryptoHashAlgorithm, byte[] buf, int off, int len) {
        this.checkAlive();
        TlsHMAC hmac = this.getCrypto().createHMACForHash(cryptoHashAlgorithm);
        hmac.setKey(this.data, 0, this.data.length);
        hmac.update(buf, off, len);
        return hmac.calculateMAC();
    }

    @Override
    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill((byte[])this.data, (byte)0);
            this.data = null;
        }
    }

    @Override
    public synchronized byte[] encrypt(TlsEncryptor encryptor) throws IOException {
        this.checkAlive();
        return encryptor.encrypt(this.data, 0, this.data.length);
    }

    @Override
    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] result = this.data;
        this.data = null;
        return result;
    }

    @Override
    public synchronized boolean isAlive() {
        return null != this.data;
    }

    synchronized byte[] copyData() {
        return Arrays.clone((byte[])this.data);
    }
}

