/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Author;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.RevisionInfo;
import org.asciidoctor.ast.Title;
import org.asciidoctor.jruby.ast.impl.AuthorImpl;
import org.asciidoctor.jruby.ast.impl.RevisionInfoImpl;
import org.asciidoctor.jruby.internal.CaseInsensitiveMap;

public class DocumentHeaderImpl
implements DocumentHeader {
    private Title documentTitle;
    private String pageTitle;
    private Author author;
    private List<Author> authors = new ArrayList<Author>();
    private RevisionInfo revisionInfo;
    private Map<String, Object> attributes;

    private DocumentHeaderImpl() {
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public Title getDocumentTitle() {
        return this.documentTitle;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public Author getAuthor() {
        return this.author;
    }

    public RevisionInfo getRevisionInfo() {
        return this.revisionInfo;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static DocumentHeaderImpl createDocumentHeader(Title documentTitle, String pageTitle, Map<String, Object> attributes) {
        DocumentHeaderImpl documentHeader = new DocumentHeaderImpl();
        documentHeader.documentTitle = documentTitle;
        documentHeader.pageTitle = pageTitle;
        documentHeader.attributes = new CaseInsensitiveMap<String, Object>(attributes);
        documentHeader.author = DocumentHeaderImpl.getAuthor(attributes);
        documentHeader.revisionInfo = DocumentHeaderImpl.getRevisionInfo(attributes);
        documentHeader.authors.addAll(DocumentHeaderImpl.getAuthors(attributes));
        return documentHeader;
    }

    private static List<Author> getAuthors(Map<String, Object> attributes) {
        return AuthorImpl.getAuthors(attributes);
    }

    private static Author getAuthor(Map<String, Object> attributes) {
        return AuthorImpl.getInstance(attributes);
    }

    private static RevisionInfo getRevisionInfo(Map<String, Object> attributes) {
        return RevisionInfoImpl.getInstance(attributes);
    }
}

