/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class HelveticaBold
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Helvetica-Bold";
    private static final String fullName = "Helvetica Bold";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 718;
    private static final int xHeight = 532;
    private static final int ascender = 718;
    private static final int descender = -207;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public HelveticaBold() {
        this(false);
    }

    public HelveticaBold(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 718;
    }

    public int getCapHeight(int size) {
        return size * 718;
    }

    public int getDescender(int size) {
        return size * -207;
    }

    public int getXHeight(int size) {
        return size * 532;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        HelveticaBold.width[65] = 722;
        HelveticaBold.boundingBoxes[65] = new Rectangle(20, 0, 682, 718);
        HelveticaBold.width[198] = 1000;
        HelveticaBold.boundingBoxes[198] = new Rectangle(5, 0, 949, 718);
        HelveticaBold.width[193] = 722;
        HelveticaBold.boundingBoxes[193] = new Rectangle(20, 0, 682, 936);
        HelveticaBold.width[194] = 722;
        HelveticaBold.boundingBoxes[194] = new Rectangle(20, 0, 682, 936);
        HelveticaBold.width[196] = 722;
        HelveticaBold.boundingBoxes[196] = new Rectangle(20, 0, 682, 915);
        HelveticaBold.width[192] = 722;
        HelveticaBold.boundingBoxes[192] = new Rectangle(20, 0, 682, 936);
        HelveticaBold.width[197] = 722;
        HelveticaBold.boundingBoxes[197] = new Rectangle(20, 0, 682, 962);
        HelveticaBold.width[195] = 722;
        HelveticaBold.boundingBoxes[195] = new Rectangle(20, 0, 682, 923);
        HelveticaBold.width[66] = 722;
        HelveticaBold.boundingBoxes[66] = new Rectangle(76, 0, 593, 718);
        HelveticaBold.width[67] = 722;
        HelveticaBold.boundingBoxes[67] = new Rectangle(44, -19, 640, 756);
        HelveticaBold.width[199] = 722;
        HelveticaBold.boundingBoxes[199] = new Rectangle(44, -228, 640, 965);
        HelveticaBold.width[68] = 722;
        HelveticaBold.boundingBoxes[68] = new Rectangle(76, 0, 609, 718);
        HelveticaBold.width[69] = 667;
        HelveticaBold.boundingBoxes[69] = new Rectangle(76, 0, 545, 718);
        HelveticaBold.width[201] = 667;
        HelveticaBold.boundingBoxes[201] = new Rectangle(76, 0, 545, 936);
        HelveticaBold.width[202] = 667;
        HelveticaBold.boundingBoxes[202] = new Rectangle(76, 0, 545, 936);
        HelveticaBold.width[203] = 667;
        HelveticaBold.boundingBoxes[203] = new Rectangle(76, 0, 545, 915);
        HelveticaBold.width[200] = 667;
        HelveticaBold.boundingBoxes[200] = new Rectangle(76, 0, 545, 936);
        HelveticaBold.width[208] = 722;
        HelveticaBold.boundingBoxes[208] = new Rectangle(-5, 0, 690, 718);
        HelveticaBold.width[128] = 556;
        HelveticaBold.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        HelveticaBold.width[70] = 611;
        HelveticaBold.boundingBoxes[70] = new Rectangle(76, 0, 511, 718);
        HelveticaBold.width[71] = 778;
        HelveticaBold.boundingBoxes[71] = new Rectangle(44, -19, 669, 756);
        HelveticaBold.width[72] = 722;
        HelveticaBold.boundingBoxes[72] = new Rectangle(71, 0, 580, 718);
        HelveticaBold.width[73] = 278;
        HelveticaBold.boundingBoxes[73] = new Rectangle(64, 0, 150, 718);
        HelveticaBold.width[205] = 278;
        HelveticaBold.boundingBoxes[205] = new Rectangle(64, 0, 265, 936);
        HelveticaBold.width[206] = 278;
        HelveticaBold.boundingBoxes[206] = new Rectangle(-37, 0, 353, 936);
        HelveticaBold.width[207] = 278;
        HelveticaBold.boundingBoxes[207] = new Rectangle(-21, 0, 321, 915);
        HelveticaBold.width[204] = 278;
        HelveticaBold.boundingBoxes[204] = new Rectangle(-50, 0, 264, 936);
        HelveticaBold.width[74] = 556;
        HelveticaBold.boundingBoxes[74] = new Rectangle(22, -18, 462, 736);
        HelveticaBold.width[75] = 722;
        HelveticaBold.boundingBoxes[75] = new Rectangle(87, 0, 635, 718);
        HelveticaBold.width[76] = 611;
        HelveticaBold.boundingBoxes[76] = new Rectangle(76, 0, 507, 718);
        HelveticaBold.width[77] = 833;
        HelveticaBold.boundingBoxes[77] = new Rectangle(69, 0, 696, 718);
        HelveticaBold.width[78] = 722;
        HelveticaBold.boundingBoxes[78] = new Rectangle(69, 0, 585, 718);
        HelveticaBold.width[209] = 722;
        HelveticaBold.boundingBoxes[209] = new Rectangle(69, 0, 585, 923);
        HelveticaBold.width[79] = 778;
        HelveticaBold.boundingBoxes[79] = new Rectangle(44, -19, 690, 756);
        HelveticaBold.width[140] = 1000;
        HelveticaBold.boundingBoxes[140] = new Rectangle(37, -19, 924, 756);
        HelveticaBold.width[211] = 778;
        HelveticaBold.boundingBoxes[211] = new Rectangle(44, -19, 690, 955);
        HelveticaBold.width[212] = 778;
        HelveticaBold.boundingBoxes[212] = new Rectangle(44, -19, 690, 955);
        HelveticaBold.width[214] = 778;
        HelveticaBold.boundingBoxes[214] = new Rectangle(44, -19, 690, 934);
        HelveticaBold.width[210] = 778;
        HelveticaBold.boundingBoxes[210] = new Rectangle(44, -19, 690, 955);
        HelveticaBold.width[216] = 778;
        HelveticaBold.boundingBoxes[216] = new Rectangle(33, -27, 711, 772);
        HelveticaBold.width[213] = 778;
        HelveticaBold.boundingBoxes[213] = new Rectangle(44, -19, 690, 942);
        HelveticaBold.width[80] = 667;
        HelveticaBold.boundingBoxes[80] = new Rectangle(76, 0, 551, 718);
        HelveticaBold.width[81] = 778;
        HelveticaBold.boundingBoxes[81] = new Rectangle(44, -52, 693, 789);
        HelveticaBold.width[82] = 722;
        HelveticaBold.boundingBoxes[82] = new Rectangle(76, 0, 601, 718);
        HelveticaBold.width[83] = 667;
        HelveticaBold.boundingBoxes[83] = new Rectangle(39, -19, 590, 756);
        HelveticaBold.width[138] = 667;
        HelveticaBold.boundingBoxes[138] = new Rectangle(39, -19, 590, 955);
        HelveticaBold.width[84] = 611;
        HelveticaBold.boundingBoxes[84] = new Rectangle(14, 0, 584, 718);
        HelveticaBold.width[222] = 667;
        HelveticaBold.boundingBoxes[222] = new Rectangle(76, 0, 551, 718);
        HelveticaBold.width[85] = 722;
        HelveticaBold.boundingBoxes[85] = new Rectangle(72, -19, 579, 737);
        HelveticaBold.width[218] = 722;
        HelveticaBold.boundingBoxes[218] = new Rectangle(72, -19, 579, 955);
        HelveticaBold.width[219] = 722;
        HelveticaBold.boundingBoxes[219] = new Rectangle(72, -19, 579, 955);
        HelveticaBold.width[220] = 722;
        HelveticaBold.boundingBoxes[220] = new Rectangle(72, -19, 579, 934);
        HelveticaBold.width[217] = 722;
        HelveticaBold.boundingBoxes[217] = new Rectangle(72, -19, 579, 955);
        HelveticaBold.width[86] = 667;
        HelveticaBold.boundingBoxes[86] = new Rectangle(19, 0, 629, 718);
        HelveticaBold.width[87] = 944;
        HelveticaBold.boundingBoxes[87] = new Rectangle(16, 0, 913, 718);
        HelveticaBold.width[88] = 667;
        HelveticaBold.boundingBoxes[88] = new Rectangle(14, 0, 639, 718);
        HelveticaBold.width[89] = 667;
        HelveticaBold.boundingBoxes[89] = new Rectangle(15, 0, 638, 718);
        HelveticaBold.width[221] = 667;
        HelveticaBold.boundingBoxes[221] = new Rectangle(15, 0, 638, 936);
        HelveticaBold.width[159] = 667;
        HelveticaBold.boundingBoxes[159] = new Rectangle(15, 0, 638, 915);
        HelveticaBold.width[90] = 611;
        HelveticaBold.boundingBoxes[90] = new Rectangle(25, 0, 561, 718);
        HelveticaBold.width[142] = 611;
        HelveticaBold.boundingBoxes[142] = new Rectangle(25, 0, 561, 936);
        HelveticaBold.width[97] = 556;
        HelveticaBold.boundingBoxes[97] = new Rectangle(29, -14, 498, 560);
        HelveticaBold.width[225] = 556;
        HelveticaBold.boundingBoxes[225] = new Rectangle(29, -14, 498, 764);
        HelveticaBold.width[226] = 556;
        HelveticaBold.boundingBoxes[226] = new Rectangle(29, -14, 498, 764);
        HelveticaBold.width[180] = 333;
        HelveticaBold.boundingBoxes[180] = new Rectangle(108, 604, 248, 146);
        HelveticaBold.width[228] = 556;
        HelveticaBold.boundingBoxes[228] = new Rectangle(29, -14, 498, 743);
        HelveticaBold.width[230] = 889;
        HelveticaBold.boundingBoxes[230] = new Rectangle(29, -14, 829, 560);
        HelveticaBold.width[224] = 556;
        HelveticaBold.boundingBoxes[224] = new Rectangle(29, -14, 498, 764);
        HelveticaBold.width[38] = 722;
        HelveticaBold.boundingBoxes[38] = new Rectangle(54, -19, 647, 737);
        HelveticaBold.width[229] = 556;
        HelveticaBold.boundingBoxes[229] = new Rectangle(29, -14, 498, 790);
        HelveticaBold.width[94] = 584;
        HelveticaBold.boundingBoxes[94] = new Rectangle(62, 323, 460, 375);
        HelveticaBold.width[126] = 584;
        HelveticaBold.boundingBoxes[126] = new Rectangle(61, 163, 462, 180);
        HelveticaBold.width[42] = 389;
        HelveticaBold.boundingBoxes[42] = new Rectangle(27, 387, 335, 331);
        HelveticaBold.width[64] = 975;
        HelveticaBold.boundingBoxes[64] = new Rectangle(118, -19, 738, 756);
        HelveticaBold.width[227] = 556;
        HelveticaBold.boundingBoxes[227] = new Rectangle(29, -14, 498, 751);
        HelveticaBold.width[98] = 611;
        HelveticaBold.boundingBoxes[98] = new Rectangle(61, -14, 517, 732);
        HelveticaBold.width[92] = 278;
        HelveticaBold.boundingBoxes[92] = new Rectangle(-33, -19, 344, 756);
        HelveticaBold.width[124] = 280;
        HelveticaBold.boundingBoxes[124] = new Rectangle(84, -225, 112, 1000);
        HelveticaBold.width[123] = 389;
        HelveticaBold.boundingBoxes[123] = new Rectangle(48, -196, 317, 918);
        HelveticaBold.width[125] = 389;
        HelveticaBold.boundingBoxes[125] = new Rectangle(24, -196, 317, 918);
        HelveticaBold.width[91] = 333;
        HelveticaBold.boundingBoxes[91] = new Rectangle(63, -196, 246, 918);
        HelveticaBold.width[93] = 333;
        HelveticaBold.boundingBoxes[93] = new Rectangle(24, -196, 246, 918);
        HelveticaBold.width[166] = 280;
        HelveticaBold.boundingBoxes[166] = new Rectangle(84, -150, 112, 850);
        HelveticaBold.width[149] = 350;
        HelveticaBold.boundingBoxes[149] = new Rectangle(10, 194, 330, 330);
        HelveticaBold.width[99] = 556;
        HelveticaBold.boundingBoxes[99] = new Rectangle(34, -14, 490, 560);
        HelveticaBold.width[231] = 556;
        HelveticaBold.boundingBoxes[231] = new Rectangle(34, -228, 490, 774);
        HelveticaBold.width[184] = 333;
        HelveticaBold.boundingBoxes[184] = new Rectangle(6, -228, 239, 228);
        HelveticaBold.width[162] = 556;
        HelveticaBold.boundingBoxes[162] = new Rectangle(34, -118, 490, 746);
        HelveticaBold.width[136] = 333;
        HelveticaBold.boundingBoxes[136] = new Rectangle(-10, 604, 353, 146);
        HelveticaBold.width[58] = 333;
        HelveticaBold.boundingBoxes[58] = new Rectangle(92, 0, 150, 512);
        HelveticaBold.width[44] = 278;
        HelveticaBold.boundingBoxes[44] = new Rectangle(64, -168, 150, 314);
        HelveticaBold.width[169] = 737;
        HelveticaBold.boundingBoxes[169] = new Rectangle(-11, -19, 760, 756);
        HelveticaBold.width[164] = 556;
        HelveticaBold.boundingBoxes[164] = new Rectangle(-3, 76, 562, 560);
        HelveticaBold.width[100] = 611;
        HelveticaBold.boundingBoxes[100] = new Rectangle(34, -14, 517, 732);
        HelveticaBold.width[134] = 556;
        HelveticaBold.boundingBoxes[134] = new Rectangle(36, -171, 484, 889);
        HelveticaBold.width[135] = 556;
        HelveticaBold.boundingBoxes[135] = new Rectangle(36, -171, 484, 889);
        HelveticaBold.width[176] = 400;
        HelveticaBold.boundingBoxes[176] = new Rectangle(57, 426, 286, 286);
        HelveticaBold.width[168] = 333;
        HelveticaBold.boundingBoxes[168] = new Rectangle(6, 614, 321, 115);
        HelveticaBold.width[247] = 584;
        HelveticaBold.boundingBoxes[247] = new Rectangle(40, -42, 504, 590);
        HelveticaBold.width[36] = 556;
        HelveticaBold.boundingBoxes[36] = new Rectangle(30, -115, 493, 890);
        HelveticaBold.width[101] = 556;
        HelveticaBold.boundingBoxes[101] = new Rectangle(23, -14, 505, 560);
        HelveticaBold.width[233] = 556;
        HelveticaBold.boundingBoxes[233] = new Rectangle(23, -14, 505, 764);
        HelveticaBold.width[234] = 556;
        HelveticaBold.boundingBoxes[234] = new Rectangle(23, -14, 505, 764);
        HelveticaBold.width[235] = 556;
        HelveticaBold.boundingBoxes[235] = new Rectangle(23, -14, 505, 743);
        HelveticaBold.width[232] = 556;
        HelveticaBold.boundingBoxes[232] = new Rectangle(23, -14, 505, 764);
        HelveticaBold.width[56] = 556;
        HelveticaBold.boundingBoxes[56] = new Rectangle(32, -19, 492, 729);
        HelveticaBold.width[133] = 1000;
        HelveticaBold.boundingBoxes[133] = new Rectangle(92, 0, 816, 146);
        HelveticaBold.width[151] = 1000;
        HelveticaBold.boundingBoxes[151] = new Rectangle(0, 227, 1000, 106);
        HelveticaBold.width[150] = 556;
        HelveticaBold.boundingBoxes[150] = new Rectangle(0, 227, 556, 106);
        HelveticaBold.width[61] = 584;
        HelveticaBold.boundingBoxes[61] = new Rectangle(40, 87, 504, 332);
        HelveticaBold.width[240] = 611;
        HelveticaBold.boundingBoxes[240] = new Rectangle(34, -14, 544, 751);
        HelveticaBold.width[33] = 333;
        HelveticaBold.boundingBoxes[33] = new Rectangle(90, 0, 154, 718);
        HelveticaBold.width[161] = 333;
        HelveticaBold.boundingBoxes[161] = new Rectangle(90, -186, 154, 718);
        HelveticaBold.width[102] = 333;
        HelveticaBold.boundingBoxes[102] = new Rectangle(10, 0, 308, 727);
        HelveticaBold.width[53] = 556;
        HelveticaBold.boundingBoxes[53] = new Rectangle(27, -19, 489, 717);
        HelveticaBold.width[131] = 556;
        HelveticaBold.boundingBoxes[131] = new Rectangle(-10, -210, 526, 947);
        HelveticaBold.width[52] = 556;
        HelveticaBold.boundingBoxes[52] = new Rectangle(27, 0, 499, 710);
        HelveticaBold.width[103] = 611;
        HelveticaBold.boundingBoxes[103] = new Rectangle(40, -217, 513, 763);
        HelveticaBold.width[223] = 611;
        HelveticaBold.boundingBoxes[223] = new Rectangle(69, -14, 510, 745);
        HelveticaBold.width[96] = 333;
        HelveticaBold.boundingBoxes[96] = new Rectangle(-23, 604, 248, 146);
        HelveticaBold.width[62] = 584;
        HelveticaBold.boundingBoxes[62] = new Rectangle(38, -8, 508, 522);
        HelveticaBold.width[171] = 556;
        HelveticaBold.boundingBoxes[171] = new Rectangle(88, 76, 380, 408);
        HelveticaBold.width[187] = 556;
        HelveticaBold.boundingBoxes[187] = new Rectangle(88, 76, 380, 408);
        HelveticaBold.width[139] = 333;
        HelveticaBold.boundingBoxes[139] = new Rectangle(83, 76, 167, 408);
        HelveticaBold.width[155] = 333;
        HelveticaBold.boundingBoxes[155] = new Rectangle(83, 76, 167, 408);
        HelveticaBold.width[104] = 611;
        HelveticaBold.boundingBoxes[104] = new Rectangle(65, 0, 481, 718);
        HelveticaBold.width[45] = 333;
        HelveticaBold.boundingBoxes[45] = new Rectangle(27, 215, 279, 130);
        HelveticaBold.width[105] = 278;
        HelveticaBold.boundingBoxes[105] = new Rectangle(69, 0, 140, 725);
        HelveticaBold.width[237] = 278;
        HelveticaBold.boundingBoxes[237] = new Rectangle(69, 0, 260, 750);
        HelveticaBold.width[238] = 278;
        HelveticaBold.boundingBoxes[238] = new Rectangle(-37, 0, 353, 750);
        HelveticaBold.width[239] = 278;
        HelveticaBold.boundingBoxes[239] = new Rectangle(-21, 0, 321, 729);
        HelveticaBold.width[236] = 278;
        HelveticaBold.boundingBoxes[236] = new Rectangle(-50, 0, 259, 750);
        HelveticaBold.width[106] = 278;
        HelveticaBold.boundingBoxes[106] = new Rectangle(3, -214, 206, 939);
        HelveticaBold.width[107] = 556;
        HelveticaBold.boundingBoxes[107] = new Rectangle(69, 0, 493, 718);
        HelveticaBold.width[108] = 278;
        HelveticaBold.boundingBoxes[108] = new Rectangle(69, 0, 140, 718);
        HelveticaBold.width[60] = 584;
        HelveticaBold.boundingBoxes[60] = new Rectangle(38, -8, 508, 522);
        HelveticaBold.width[172] = 584;
        HelveticaBold.boundingBoxes[172] = new Rectangle(40, 108, 504, 311);
        HelveticaBold.width[109] = 889;
        HelveticaBold.boundingBoxes[109] = new Rectangle(64, 0, 762, 546);
        HelveticaBold.width[175] = 333;
        HelveticaBold.boundingBoxes[175] = new Rectangle(-6, 604, 345, 74);
        HelveticaBold.width[181] = 611;
        HelveticaBold.boundingBoxes[181] = new Rectangle(66, -207, 479, 739);
        HelveticaBold.width[215] = 584;
        HelveticaBold.boundingBoxes[215] = new Rectangle(40, 1, 505, 504);
        HelveticaBold.width[110] = 611;
        HelveticaBold.boundingBoxes[110] = new Rectangle(65, 0, 481, 546);
        HelveticaBold.width[57] = 556;
        HelveticaBold.boundingBoxes[57] = new Rectangle(30, -19, 492, 729);
        HelveticaBold.width[241] = 611;
        HelveticaBold.boundingBoxes[241] = new Rectangle(65, 0, 481, 737);
        HelveticaBold.width[35] = 556;
        HelveticaBold.boundingBoxes[35] = new Rectangle(18, 0, 520, 698);
        HelveticaBold.width[111] = 611;
        HelveticaBold.boundingBoxes[111] = new Rectangle(34, -14, 544, 560);
        HelveticaBold.width[243] = 611;
        HelveticaBold.boundingBoxes[243] = new Rectangle(34, -14, 544, 764);
        HelveticaBold.width[244] = 611;
        HelveticaBold.boundingBoxes[244] = new Rectangle(34, -14, 544, 764);
        HelveticaBold.width[246] = 611;
        HelveticaBold.boundingBoxes[246] = new Rectangle(34, -14, 544, 743);
        HelveticaBold.width[156] = 944;
        HelveticaBold.boundingBoxes[156] = new Rectangle(34, -14, 878, 560);
        HelveticaBold.width[242] = 611;
        HelveticaBold.boundingBoxes[242] = new Rectangle(34, -14, 544, 764);
        HelveticaBold.width[49] = 556;
        HelveticaBold.boundingBoxes[49] = new Rectangle(69, 0, 309, 710);
        HelveticaBold.width[189] = 834;
        HelveticaBold.boundingBoxes[189] = new Rectangle(26, -19, 768, 729);
        HelveticaBold.width[188] = 834;
        HelveticaBold.boundingBoxes[188] = new Rectangle(26, -19, 740, 729);
        HelveticaBold.width[185] = 333;
        HelveticaBold.boundingBoxes[185] = new Rectangle(26, 283, 211, 427);
        HelveticaBold.width[170] = 370;
        HelveticaBold.boundingBoxes[170] = new Rectangle(22, 401, 325, 336);
        HelveticaBold.width[186] = 365;
        HelveticaBold.boundingBoxes[186] = new Rectangle(6, 401, 354, 336);
        HelveticaBold.width[248] = 611;
        HelveticaBold.boundingBoxes[248] = new Rectangle(22, -29, 567, 589);
        HelveticaBold.width[245] = 611;
        HelveticaBold.boundingBoxes[245] = new Rectangle(34, -14, 544, 751);
        HelveticaBold.width[112] = 611;
        HelveticaBold.boundingBoxes[112] = new Rectangle(62, -207, 516, 753);
        HelveticaBold.width[182] = 556;
        HelveticaBold.boundingBoxes[182] = new Rectangle(-8, -191, 547, 891);
        HelveticaBold.width[40] = 333;
        HelveticaBold.boundingBoxes[40] = new Rectangle(35, -208, 279, 942);
        HelveticaBold.width[41] = 333;
        HelveticaBold.boundingBoxes[41] = new Rectangle(19, -208, 279, 942);
        HelveticaBold.width[37] = 889;
        HelveticaBold.boundingBoxes[37] = new Rectangle(28, -19, 833, 729);
        HelveticaBold.width[46] = 278;
        HelveticaBold.boundingBoxes[46] = new Rectangle(64, 0, 150, 146);
        HelveticaBold.width[183] = 278;
        HelveticaBold.boundingBoxes[183] = new Rectangle(58, 172, 162, 162);
        HelveticaBold.width[137] = 1000;
        HelveticaBold.boundingBoxes[137] = new Rectangle(-3, -19, 1006, 729);
        HelveticaBold.width[43] = 584;
        HelveticaBold.boundingBoxes[43] = new Rectangle(40, 0, 504, 506);
        HelveticaBold.width[177] = 584;
        HelveticaBold.boundingBoxes[177] = new Rectangle(40, 0, 504, 506);
        HelveticaBold.width[113] = 611;
        HelveticaBold.boundingBoxes[113] = new Rectangle(34, -207, 518, 753);
        HelveticaBold.width[63] = 611;
        HelveticaBold.boundingBoxes[63] = new Rectangle(60, 0, 496, 727);
        HelveticaBold.width[191] = 611;
        HelveticaBold.boundingBoxes[191] = new Rectangle(55, -195, 496, 727);
        HelveticaBold.width[34] = 474;
        HelveticaBold.boundingBoxes[34] = new Rectangle(98, 447, 278, 271);
        HelveticaBold.width[132] = 500;
        HelveticaBold.boundingBoxes[132] = new Rectangle(64, -146, 372, 273);
        HelveticaBold.width[147] = 500;
        HelveticaBold.boundingBoxes[147] = new Rectangle(64, 454, 372, 273);
        HelveticaBold.width[148] = 500;
        HelveticaBold.boundingBoxes[148] = new Rectangle(64, 445, 372, 273);
        HelveticaBold.width[145] = 278;
        HelveticaBold.boundingBoxes[145] = new Rectangle(69, 454, 140, 273);
        HelveticaBold.width[146] = 278;
        HelveticaBold.boundingBoxes[146] = new Rectangle(69, 445, 140, 273);
        HelveticaBold.width[130] = 278;
        HelveticaBold.boundingBoxes[130] = new Rectangle(69, -146, 140, 273);
        HelveticaBold.width[39] = 238;
        HelveticaBold.boundingBoxes[39] = new Rectangle(70, 447, 98, 271);
        HelveticaBold.width[114] = 389;
        HelveticaBold.boundingBoxes[114] = new Rectangle(64, 0, 309, 546);
        HelveticaBold.width[174] = 737;
        HelveticaBold.boundingBoxes[174] = new Rectangle(-11, -19, 759, 756);
        HelveticaBold.width[115] = 556;
        HelveticaBold.boundingBoxes[115] = new Rectangle(30, -14, 489, 560);
        HelveticaBold.width[154] = 556;
        HelveticaBold.boundingBoxes[154] = new Rectangle(30, -14, 489, 764);
        HelveticaBold.width[167] = 556;
        HelveticaBold.boundingBoxes[167] = new Rectangle(34, -184, 488, 911);
        HelveticaBold.width[59] = 333;
        HelveticaBold.boundingBoxes[59] = new Rectangle(92, -168, 150, 680);
        HelveticaBold.width[55] = 556;
        HelveticaBold.boundingBoxes[55] = new Rectangle(25, 0, 503, 698);
        HelveticaBold.width[54] = 556;
        HelveticaBold.boundingBoxes[54] = new Rectangle(31, -19, 489, 729);
        HelveticaBold.width[47] = 278;
        HelveticaBold.boundingBoxes[47] = new Rectangle(-33, -19, 344, 756);
        HelveticaBold.width[32] = 278;
        HelveticaBold.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        HelveticaBold.width[163] = 556;
        HelveticaBold.boundingBoxes[163] = new Rectangle(28, -16, 513, 734);
        HelveticaBold.width[116] = 333;
        HelveticaBold.boundingBoxes[116] = new Rectangle(10, -6, 299, 682);
        HelveticaBold.width[254] = 611;
        HelveticaBold.boundingBoxes[254] = new Rectangle(62, -208, 516, 926);
        HelveticaBold.width[51] = 556;
        HelveticaBold.boundingBoxes[51] = new Rectangle(27, -19, 489, 729);
        HelveticaBold.width[190] = 834;
        HelveticaBold.boundingBoxes[190] = new Rectangle(16, -19, 783, 729);
        HelveticaBold.width[179] = 333;
        HelveticaBold.boundingBoxes[179] = new Rectangle(8, 271, 318, 439);
        HelveticaBold.width[152] = 333;
        HelveticaBold.boundingBoxes[152] = new Rectangle(-17, 610, 367, 127);
        HelveticaBold.width[153] = 1000;
        HelveticaBold.boundingBoxes[153] = new Rectangle(44, 306, 912, 412);
        HelveticaBold.width[50] = 556;
        HelveticaBold.boundingBoxes[50] = new Rectangle(26, 0, 485, 710);
        HelveticaBold.width[178] = 333;
        HelveticaBold.boundingBoxes[178] = new Rectangle(9, 283, 315, 427);
        HelveticaBold.width[117] = 611;
        HelveticaBold.boundingBoxes[117] = new Rectangle(66, -14, 479, 546);
        HelveticaBold.width[250] = 611;
        HelveticaBold.boundingBoxes[250] = new Rectangle(66, -14, 479, 764);
        HelveticaBold.width[251] = 611;
        HelveticaBold.boundingBoxes[251] = new Rectangle(66, -14, 479, 764);
        HelveticaBold.width[252] = 611;
        HelveticaBold.boundingBoxes[252] = new Rectangle(66, -14, 479, 743);
        HelveticaBold.width[249] = 611;
        HelveticaBold.boundingBoxes[249] = new Rectangle(66, -14, 479, 764);
        HelveticaBold.width[95] = 556;
        HelveticaBold.boundingBoxes[95] = new Rectangle(0, -125, 556, 50);
        HelveticaBold.width[118] = 556;
        HelveticaBold.boundingBoxes[118] = new Rectangle(13, 0, 530, 532);
        HelveticaBold.width[119] = 778;
        HelveticaBold.boundingBoxes[119] = new Rectangle(10, 0, 759, 532);
        HelveticaBold.width[120] = 556;
        HelveticaBold.boundingBoxes[120] = new Rectangle(15, 0, 526, 532);
        HelveticaBold.width[121] = 556;
        HelveticaBold.boundingBoxes[121] = new Rectangle(10, -214, 529, 746);
        HelveticaBold.width[253] = 556;
        HelveticaBold.boundingBoxes[253] = new Rectangle(10, -214, 529, 964);
        HelveticaBold.width[255] = 556;
        HelveticaBold.boundingBoxes[255] = new Rectangle(10, -214, 529, 943);
        HelveticaBold.width[165] = 556;
        HelveticaBold.boundingBoxes[165] = new Rectangle(-9, 0, 574, 698);
        HelveticaBold.width[122] = 500;
        HelveticaBold.boundingBoxes[122] = new Rectangle(20, 0, 460, 532);
        HelveticaBold.width[158] = 500;
        HelveticaBold.boundingBoxes[158] = new Rectangle(20, 0, 460, 750);
        HelveticaBold.width[48] = 556;
        HelveticaBold.boundingBoxes[48] = new Rectangle(32, -19, 492, 729);
        kerning = new HashMap();
        Integer first = new Integer(107);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(111);
        pairs.put(second, new Integer(-15));
        first = new Integer(79);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(87);
        pairs.put(second, new Integer(-50));
        second = new Integer(89);
        pairs.put(second, new Integer(-70));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(-20));
        second = new Integer(104);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-10));
        second = new Integer(108);
        pairs.put(second, new Integer(-20));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-60));
        second = new Integer(45);
        pairs.put(second, new Integer(-40));
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(58);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(-40));
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(117);
        pairs.put(second, new Integer(-45));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-35));
        second = new Integer(59);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-40));
        second = new Integer(97);
        pairs.put(second, new Integer(-30));
        second = new Integer(65);
        pairs.put(second, new Integer(-100));
        second = new Integer(46);
        pairs.put(second, new Integer(-120));
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-120));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-90));
        second = new Integer(45);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-50));
        second = new Integer(58);
        pairs.put(second, new Integer(-40));
        second = new Integer(97);
        pairs.put(second, new Integer(-60));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-120));
        second = new Integer(71);
        pairs.put(second, new Integer(-50));
        second = new Integer(101);
        pairs.put(second, new Integer(-50));
        second = new Integer(59);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-120));
        first = new Integer(59);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-30));
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(87);
        pairs.put(second, new Integer(-80));
        second = new Integer(147);
        pairs.put(second, new Integer(-80));
        second = new Integer(89);
        pairs.put(second, new Integer(-120));
        second = new Integer(84);
        pairs.put(second, new Integer(-100));
        second = new Integer(145);
        pairs.put(second, new Integer(-60));
        second = new Integer(86);
        pairs.put(second, new Integer(-80));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(119);
        pairs.put(second, new Integer(-30));
        second = new Integer(87);
        pairs.put(second, new Integer(-60));
        second = new Integer(67);
        pairs.put(second, new Integer(-40));
        second = new Integer(81);
        pairs.put(second, new Integer(-40));
        second = new Integer(71);
        pairs.put(second, new Integer(-50));
        second = new Integer(86);
        pairs.put(second, new Integer(-80));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        second = new Integer(85);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-110));
        second = new Integer(84);
        pairs.put(second, new Integer(-90));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(44);
        pairs.put(second, new Integer(-100));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(120);
        pairs.put(second, new Integer(-30));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(10));
        first = new Integer(100);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(-10));
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-70));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(86);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(-80));
        second = new Integer(32);
        pairs.put(second, new Integer(-80));
        second = new Integer(146);
        pairs.put(second, new Integer(-46));
        second = new Integer(114);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(-20));
        second = new Integer(115);
        pairs.put(second, new Integer(-60));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(85);
        pairs.put(second, new Integer(-20));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-20));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-35));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(121);
        pairs.put(second, new Integer(-40));
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(100);
        pairs.put(second, new Integer(-20));
        second = new Integer(45);
        pairs.put(second, new Integer(-20));
        second = new Integer(99);
        pairs.put(second, new Integer(-20));
        second = new Integer(116);
        pairs.put(second, new Integer(20));
        second = new Integer(121);
        pairs.put(second, new Integer(10));
        second = new Integer(46);
        pairs.put(second, new Integer(-60));
        second = new Integer(103);
        pairs.put(second, new Integer(-15));
        second = new Integer(113);
        pairs.put(second, new Integer(-20));
        second = new Integer(115);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(10));
        second = new Integer(44);
        pairs.put(second, new Integer(-60));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(145);
        pairs.put(second, new Integer(-46));
        first = new Integer(108);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(10));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-30));
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(108);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-140));
        second = new Integer(146);
        pairs.put(second, new Integer(-140));
        second = new Integer(87);
        pairs.put(second, new Integer(-80));
        second = new Integer(89);
        pairs.put(second, new Integer(-120));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(84);
        pairs.put(second, new Integer(-90));
        second = new Integer(86);
        pairs.put(second, new Integer(-110));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(20));
        second = new Integer(44);
        pairs.put(second, new Integer(20));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-120));
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        second = new Integer(146);
        pairs.put(second, new Integer(-120));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-80));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(30));
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(146);
        pairs.put(second, new Integer(30));
        second = new Integer(46);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-10));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-20));
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-20));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-100));
        second = new Integer(79);
        pairs.put(second, new Integer(-70));
        second = new Integer(58);
        pairs.put(second, new Integer(-50));
        second = new Integer(97);
        pairs.put(second, new Integer(-90));
        second = new Integer(65);
        pairs.put(second, new Integer(-110));
        second = new Integer(117);
        pairs.put(second, new Integer(-100));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(101);
        pairs.put(second, new Integer(-80));
        second = new Integer(59);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-100));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(58);
        pairs.put(second, new Integer(-40));
        second = new Integer(119);
        pairs.put(second, new Integer(-60));
        second = new Integer(114);
        pairs.put(second, new Integer(-80));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        second = new Integer(59);
        pairs.put(second, new Integer(-40));
        second = new Integer(45);
        pairs.put(second, new Integer(-120));
        second = new Integer(65);
        pairs.put(second, new Integer(-90));
        second = new Integer(97);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-90));
        second = new Integer(121);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-60));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(97);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-120));
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        second = new Integer(146);
        pairs.put(second, new Integer(-120));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(46);
        pairs.put(second, new Integer(20));
        second = new Integer(120);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(10));
        familyNames = new HashSet();
        familyNames.add("Helvetica");
    }
}

