/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListItem
extends FObj
implements BreakPropertySet,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private int breakAfter;
    private int breakBefore;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private ListItemLabel label;
    private ListItemBody body;

    public ListItem(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonAccessibility = CommonAccessibility.getInstance(pList);
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.keepTogether = pList.get(131).getKeep();
        this.keepWithNext = pList.get(132).getKeep();
        this.keepWithPrevious = pList.get(133).getKeep();
    }

    @Override
    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startListItem(this);
    }

    @Override
    public void endOfNode() throws FOPException {
        if (this.label == null || this.body == null) {
            this.missingChildElementError("marker* (list-item-label,list-item-body)");
        }
        this.getFOEventHandler().endListItem(this);
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.label != null) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "fo:list-item-label");
                }
            } else if (localName.equals("list-item-label")) {
                if (this.label != null) {
                    this.tooManyNodesError(loc, "fo:list-item-label");
                }
            } else if (localName.equals("list-item-body")) {
                if (this.label == null) {
                    this.nodesOutOfOrderError(loc, "fo:list-item-label", "fo:list-item-body");
                } else if (this.body != null) {
                    this.tooManyNodesError(loc, "fo:list-item-body");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        }
    }

    @Override
    public void addChildNode(FONode child) {
        int nameId = child.getNameId();
        if (nameId == 43) {
            this.label = (ListItemLabel)child;
        } else if (nameId == 42) {
            this.body = (ListItemBody)child;
        } else if (nameId == 44) {
            this.addMarker((Marker)child);
        }
    }

    @Override
    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    @Override
    public int getBreakAfter() {
        return this.breakAfter;
    }

    @Override
    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public ListItemLabel getLabel() {
        return this.label;
    }

    public ListItemBody getBody() {
        return this.body;
    }

    @Override
    public String getLocalName() {
        return "list-item";
    }

    @Override
    public int getNameId() {
        return 41;
    }

    @Override
    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> ranges, DelimitedTextRange currentRange) {
        ListItemBody body;
        ListItemLabel label = this.getLabel();
        if (label != null) {
            ranges = label.collectDelimitedTextRanges(ranges);
        }
        if ((body = this.getBody()) != null) {
            ranges = body.collectDelimitedTextRanges(ranges);
        }
        return ranges;
    }
}

