/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.ApplicationRequestDecoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoder;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class KerberosTokenDecoderImpl
implements KerberosTokenDecoder {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private byte[] serviceTicket;
    private Subject subject;
    private boolean decoded = false;
    private EncTicketPart encTicketPart;

    @Override
    public void clear() {
        this.serviceTicket = null;
        this.subject = null;
        this.decoded = false;
        this.encTicketPart = null;
    }

    @Override
    public void setToken(byte[] token) {
        this.serviceTicket = token;
    }

    @Override
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @Override
    public byte[] getSessionKey() throws KerberosTokenDecoderException {
        if (!this.decoded) {
            this.decodeServiceTicket();
        }
        if (this.encTicketPart != null && this.encTicketPart.getSessionKey() != null) {
            return this.encTicketPart.getSessionKey().getKeyValue();
        }
        return null;
    }

    public String getClientPrincipalName() throws KerberosTokenDecoderException {
        if (!this.decoded) {
            this.decodeServiceTicket();
        }
        return this.encTicketPart.getClientPrincipal().toString();
    }

    private synchronized void decodeServiceTicket() throws KerberosTokenDecoderException {
        this.parseServiceTicket(this.serviceTicket);
        this.decoded = true;
    }

    private void parseServiceTicket(byte[] ticket) throws KerberosTokenDecoderException {
        try {
            ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(ticket));
            DERApplicationSpecific derToken = (DERApplicationSpecific)asn1InputStream.readObject();
            if (derToken == null || !derToken.isConstructed()) {
                asn1InputStream.close();
                throw new KerberosTokenDecoderException("invalid kerberos token");
            }
            asn1InputStream.close();
            asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(derToken.getContents()));
            DERObjectIdentifier kerberosOid = (DERObjectIdentifier)asn1InputStream.readObject();
            if (!kerberosOid.getId().equals(KERBEROS_OID)) {
                asn1InputStream.close();
                throw new KerberosTokenDecoderException("invalid kerberos token");
            }
            int readLowByte = asn1InputStream.read() & 0xFF;
            int readHighByte = asn1InputStream.read() & 0xFF;
            int read = (readHighByte << 8) + readLowByte;
            if (read != 1) {
                throw new KerberosTokenDecoderException("invalid kerberos token");
            }
            ApplicationRequestDecoder applicationRequestDecoder = new ApplicationRequestDecoder();
            ApplicationRequest applicationRequest = applicationRequestDecoder.decode(KerberosTokenDecoderImpl.toByteArray((InputStream)asn1InputStream));
            int encryptionType = applicationRequest.getTicket().getEncPart().getEType().getOrdinal();
            KerberosKey kerberosKey = this.getKrbKey(this.subject, encryptionType);
            EncryptionKey encryptionKey = new EncryptionKey(EncryptionType.getTypeByOrdinal((int)encryptionType), kerberosKey.getEncoded());
            CipherTextHandler cipherTextHandler = new CipherTextHandler();
            this.encTicketPart = (EncTicketPart)cipherTextHandler.unseal(EncTicketPart.class, encryptionKey, applicationRequest.getTicket().getEncPart(), KeyUsage.NUMBER2);
        }
        catch (KerberosException e) {
            throw new KerberosTokenDecoderException(e);
        }
        catch (IOException e) {
            throw new KerberosTokenDecoderException(e);
        }
    }

    private KerberosKey getKrbKey(Subject sub, int keyType) {
        Set<Object> creds = sub.getPrivateCredentials(Object.class);
        for (Object cred : creds) {
            KerberosKey key;
            if (!(cred instanceof KerberosKey) || (key = (KerberosKey)cred).getKeyType() != keyType) continue;
            return (KerberosKey)cred;
        }
        return null;
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((read = inputStream.read(buf)) != -1) {
            byteArrayOutputStream.write(buf, 0, read);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

