/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedKeyTokenSTRParser
implements STRParser {
    private byte[] secretKey;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        boolean bspCompliant = true;
        Crypto crypto = data.getDecCrypto();
        WSSConfig config = data.getWssConfig();
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, bspCompliant);
        String uri = null;
        String keyIdentifierValueType = null;
        String keyIdentifierValue = null;
        WSSecurityEngineResult result = null;
        if (secRef.containsReference()) {
            Reference ref = secRef.getReference();
            uri = ref.getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            result = wsDocInfo.getResult(uri);
        } else {
            keyIdentifierValue = secRef.getKeyIdentifierValue();
            keyIdentifierValueType = secRef.getKeyIdentifierValueType();
            result = wsDocInfo.getResult(keyIdentifierValue);
        }
        if (result != null) {
            int action = (Integer)result.get("action");
            if (8192 == action || 1 == action) {
                if (bspCompliant) {
                    BSPEnforcer.checkUsernameTokenBSPCompliance(secRef);
                }
                UsernameToken usernameToken = (UsernameToken)result.get("username-token");
                usernameToken.setRawPassword(data);
                this.secretKey = usernameToken.getDerivedKey();
                return;
            } else if (4 == action) {
                if (bspCompliant) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                this.secretKey = (byte[])result.get("secret");
                return;
            } else if (1024 == action) {
                this.secretKey = (byte[])result.get("secret");
                return;
            } else {
                if (8 != action && 16 != action) throw new WSSecurityException(6, "unsupportedKeyId");
                AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                this.secretKey = keyInfo.getSecret();
            }
            return;
        } else if (result == null && uri != null) {
            this.secretKey = this.getSecretKeyFromToken(uri, null, 6, data);
            return;
        } else {
            X509Certificate[] certs;
            if (keyIdentifierValue == null || keyIdentifierValueType == null) throw new WSSecurityException(6, "unsupportedKeyId");
            if (bspCompliant && keyIdentifierValueType.equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
            }
            this.secretKey = (certs = secRef.getKeyIdentifier(crypto)) == null || certs.length < 1 || certs[0] == null ? this.getSecretKeyFromToken(keyIdentifierValue, keyIdentifierValueType, 9, data) : crypto.getPrivateKey(certs[0], data.getCallbackHandler()).getEncoded();
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    private byte[] getSecretKeyFromToken(String id, String type, int identifier, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, identifier, data);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            data.getCallbackHandler().handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
        }
        return pwcb.getKey();
    }
}

