/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private final ISpringContextLocator contextLocator;
    private final ConcurrentMap<SpringBeanLocator, Object> cache = Generics.newConcurrentHashMap();
    private final ConcurrentMap<Class<?>, String> beanNameCache = Generics.newConcurrentHashMap();
    private final boolean wrapInProxies;

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        this(contextLocator, true);
    }

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator, boolean wrapInProxies) {
        if (contextLocator == null) {
            throw new IllegalArgumentException("[contextLocator] argument cannot be null");
        }
        this.contextLocator = contextLocator;
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (this.supportsField(field)) {
            String beanName = this.getBeanName(field);
            if (beanName == null) {
                return null;
            }
            SpringBeanLocator locator = new SpringBeanLocator(beanName, field.getType(), this.contextLocator);
            Object cachedValue = this.cache.get(locator);
            if (cachedValue != null) {
                return cachedValue;
            }
            Object target = this.wrapInProxies ? LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator) : locator.locateProxyTarget();
            if (locator.isSingletonBean()) {
                this.cache.put(locator, target);
            }
            return target;
        }
        return null;
    }

    private String getBeanName(Field field) {
        SpringBean annot = field.getAnnotation(SpringBean.class);
        String name = annot.name();
        if (Strings.isEmpty((CharSequence)name) && (name = (String)this.beanNameCache.get(field.getType())) == null && (name = this.getBeanNameOfClass(this.contextLocator.getSpringContext(), field.getType(), annot)) != null) {
            this.beanNameCache.put(field.getType(), name);
        }
        return name;
    }

    private final String getBeanNameOfClass(ApplicationContext ctx, Class<?> clazz, SpringBean annot) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)ctx, clazz)));
        if (ctx instanceof AbstractApplicationContext) {
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String possibility = (String)it.next();
                BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), possibility);
                if (!BeanFactoryUtils.isFactoryDereference((String)possibility) && !possibility.startsWith("scopedTarget.") && (beanDef == null || beanDef.isAutowireCandidate())) continue;
                it.remove();
            }
        }
        if (names.isEmpty()) {
            if (annot.required()) {
                throw new IllegalStateException("bean of type [" + clazz.getName() + "] not found");
            }
            return null;
        }
        if (names.size() > 1) {
            if (ctx instanceof AbstractApplicationContext) {
                ArrayList<String> primaries = new ArrayList<String>();
                for (String name : names) {
                    BeanDefinition beanDef = this.getBeanDefinition(((AbstractApplicationContext)ctx).getBeanFactory(), name);
                    if (!(beanDef instanceof AbstractBeanDefinition) || !beanDef.isPrimary()) continue;
                    primaries.add(name);
                }
                if (primaries.size() == 1) {
                    return (String)primaries.get(0);
                }
            }
            StringBuilder msg = new StringBuilder();
            msg.append("More than one bean of type [");
            msg.append(clazz.getName());
            msg.append("] found, you have to specify the name of the bean ");
            msg.append("(@SpringBean(name=\"foo\")) in order to resolve this conflict. ");
            msg.append("Matched beans: ");
            msg.append(Strings.join((String)",", (String[])names.toArray(new String[names.size()])));
            throw new IllegalStateException(msg.toString());
        }
        return (String)names.get(0);
    }

    private BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory beanFactory, String name) {
        if (beanFactory.containsBeanDefinition(name)) {
            return beanFactory.getBeanDefinition(name);
        }
        BeanFactory parent = beanFactory.getParentBeanFactory();
        if (parent != null && parent instanceof ConfigurableListableBeanFactory) {
            return this.getBeanDefinition((ConfigurableListableBeanFactory)parent, name);
        }
        return null;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class);
    }
}

