/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class TextRequestHandler
implements IRequestHandler {
    private final String string;
    private final String contentType;
    private final String encoding;

    public TextRequestHandler(String string) {
        this("text/plain", null, string);
    }

    public TextRequestHandler(String contentType, String encoding, String string) {
        this.contentType = (String)Args.notEmpty((CharSequence)contentType, (String)"contentType");
        this.string = (String)Args.notNull((Object)string, (String)"string");
        this.encoding = encoding;
    }

    public void respond(IRequestCycle requestCycle) {
        String encoding = this.getEncoding(requestCycle);
        WebResponse response = (WebResponse)requestCycle.getResponse();
        response.setContentType(this.contentType + ";charset=" + encoding);
        try {
            byte[] bytes = this.string.getBytes(encoding);
            response.setContentLength(bytes.length);
            response.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to render string: " + e.getMessage(), e);
        }
    }

    private String getEncoding(IRequestCycle requestCycle) {
        Charset charset;
        String encoding = this.encoding;
        if (Strings.isEmpty((CharSequence)encoding) && (charset = requestCycle.getRequest().getCharset()) != null) {
            encoding = charset.name();
        }
        return encoding;
    }

    public void detach(IRequestCycle requestCycle) {
    }

    public String getString() {
        return this.string;
    }
}

