/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.guice.GuiceProxyTargetLocator;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;

public class InjectionFlagCachingGuiceComponentInjector
extends GuiceComponentInjector {
    private final Map<Class<?>, Boolean> classToDoInject = new ConcurrentHashMap();

    public InjectionFlagCachingGuiceComponentInjector(Application app, Injector injector) {
        super(app, injector);
    }

    public Object inject(Object object) {
        Class<?> current = object.getClass();
        Boolean doInject = this.classToDoInject.get(current);
        if (doInject != null && !doInject.booleanValue()) {
            return object;
        }
        boolean actualDoInject = false;
        do {
            Method[] currentMethods;
            Field[] currentFields;
            for (Field field : currentFields = current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                actualDoInject = true;
                try {
                    Annotation bindingAnnotation = InjectionFlagCachingGuiceComponentInjector.findBindingAnnotation(field.getAnnotations());
                    Object proxy = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)new GuiceProxyTargetLocator(field, bindingAnnotation, injectAnnotation.optional()));
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(object, proxy);
                }
                catch (IllegalAccessException e) {
                    throw new WicketRuntimeException("Error Guice-injecting field " + field.getName() + " in " + object, (Throwable)e);
                }
                catch (GuiceComponentInjector.MoreThanOneBindingException e) {
                    throw new RuntimeException("Can't have more than one BindingAnnotation on field " + field.getName() + " of class " + object.getClass().getName());
                }
            }
            for (Method method : currentMethods = current.getDeclaredMethods()) {
                Inject injectAnnotation = method.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                actualDoInject = true;
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                Class<?>[] paramTypes = method.getParameterTypes();
                Type[] genericParamTypes = method.getGenericParameterTypes();
                Object[] args = new Object[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    Type paramType = genericParamTypes[i] instanceof ParameterizedType ? ((ParameterizedType)genericParamTypes[i]).getRawType() : paramTypes[i];
                    try {
                        Annotation bindingAnnotation = InjectionFlagCachingGuiceComponentInjector.findBindingAnnotation(paramAnnotations[i]);
                        args[i] = LazyInitProxyFactory.createProxy(paramTypes[i], (IProxyTargetLocator)new GuiceProxyTargetLocator(method, i, bindingAnnotation, injectAnnotation.optional()));
                        continue;
                    }
                    catch (GuiceComponentInjector.MoreThanOneBindingException e) {
                        throw new RuntimeException("Can't have more than one BindingAnnotation on parameter " + i + "(" + paramType + ") of method " + method.getName() + " of class " + object.getClass().getName());
                    }
                }
                try {
                    method.invoke(object, args);
                }
                catch (IllegalAccessException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        if (doInject == null) {
            this.classToDoInject.put(object.getClass(), new Boolean(actualDoInject));
        }
        return object;
    }

    public void onInstantiation(Component component) {
        this.inject(component);
    }
}

