/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.repeater.data.sort;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByLink;

public abstract class AjaxFallbackOrderByLink<S>
extends OrderByLink<S>
implements IAjaxLink {
    private static final long serialVersionUID = 1L;
    private final IAjaxCallListener ajaxCallListener;

    public AjaxFallbackOrderByLink(String id, S sortProperty, ISortStateLocator<S> stateLocator, OrderByLink.ICssProvider<S> cssProvider) {
        this(id, sortProperty, stateLocator, cssProvider, null);
    }

    public AjaxFallbackOrderByLink(String id, S sortProperty, ISortStateLocator<S> stateLocator) {
        this(id, sortProperty, stateLocator, new OrderByLink.DefaultCssProvider(), null);
    }

    public AjaxFallbackOrderByLink(String id, S sortProperty, ISortStateLocator<S> stateLocator, IAjaxCallListener ajaxCallListener) {
        this(id, sortProperty, stateLocator, new OrderByLink.DefaultCssProvider(), ajaxCallListener);
    }

    public AjaxFallbackOrderByLink(String id, S sortProperty, ISortStateLocator<S> stateLocator, OrderByLink.ICssProvider<S> cssProvider, IAjaxCallListener ajaxCallListener) {
        super(id, sortProperty, stateLocator, cssProvider);
        this.ajaxCallListener = ajaxCallListener;
    }

    public void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.newAjaxEventBehavior("click")});
    }

    protected AjaxEventBehavior newAjaxEventBehavior(String event) {
        return new AjaxEventBehavior(event){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                AjaxFallbackOrderByLink.this.onClick();
                AjaxFallbackOrderByLink.this.onClick(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                if (AjaxFallbackOrderByLink.this.ajaxCallListener != null) {
                    attributes.getAjaxCallListeners().add(AjaxFallbackOrderByLink.this.ajaxCallListener);
                }
            }

            protected AjaxChannel getChannel() {
                return AjaxFallbackOrderByLink.this.getChannel();
            }
        };
    }

    protected AjaxChannel getChannel() {
        return null;
    }

    public abstract void onClick(AjaxRequestTarget var1);
}

