/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterStateModel;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.string.Strings;

public class FilterForm<T>
extends Form<T> {
    private static final long serialVersionUID = 1L;
    private final IFilterStateLocator<T> locator;

    public FilterForm(String id, IFilterStateLocator<T> locator) {
        super(id, new FilterStateModel<T>(locator));
        this.locator = locator;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)("_filter_focus_restore('" + this.getFocusTrackerFieldCssId() + "');")));
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(markupStream, openTag);
        String id = ((Object)Strings.escapeMarkup((CharSequence)this.getFocusTrackerFieldCssId())).toString();
        String value = this.getRequest().getPostParameters().getParameterValue(id).toString("");
        this.getResponse().write((CharSequence)String.format("<div style='display:inline'><input type=\"hidden\" name=\"%s\" id=\"%s\" value=\"%s\"/></div>", id, id, value));
    }

    public final String getFocusTrackerFieldCssId() {
        return this.getMarkupId() + "focus";
    }

    public final IFilterStateLocator<T> getStateLocator() {
        return this.locator;
    }

    public final void enableFocusTracking(FormComponent<?> fc) {
        fc.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                component.setOutputMarkupId(true);
                tag.put("onfocus", (CharSequence)FilterForm.this.getFocusTrackingHandler(component));
                super.onComponentTag(component, tag);
            }
        }});
    }

    public final String getFocusTrackingHandler(Component component) {
        return "_filter_focus(this, '" + this.getFocusTrackerFieldCssId() + "');";
    }
}

