/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.util.Locale;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractTreeColumn;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.PropertyResolver;

public class PropertyTreeColumn
extends AbstractTreeColumn {
    private static final long serialVersionUID = 1L;
    private IConverter converter;
    private Locale locale;
    private final String propertyExpression;

    public PropertyTreeColumn(ColumnLocation location, String header, String propertyExpression) {
        super(location, header);
        this.propertyExpression = propertyExpression;
    }

    public IConverter getConverter() {
        return this.converter;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String renderNode(TreeNode node) {
        Object result = PropertyResolver.getValue((String)this.propertyExpression, (Object)node);
        if (this.converter != null) {
            Locale locale = this.locale;
            if (locale == null) {
                locale = Session.get().getLocale();
            }
            return this.converter.convertToString(result, locale);
        }
        return result != null ? result.toString() : null;
    }

    public void setConverter(IConverter converter) {
        this.converter = converter;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

