/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletHeaderMap
implements Map<String, String> {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;

    public ServletHeaderMap(HttpServletRequest request) {
        this(request, null);
    }

    public ServletHeaderMap(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getHeader(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<String> values = this.values().iterator();
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add((Map.Entry<String, String>)new MapEntry((Object)key, (Object)this.request.getHeader(key), false));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        HttpServletRequest otherRequest = ((ServletHeaderMap)o).request;
        boolean retValue = true;
        HttpServletRequest httpServletRequest = this.request;
        synchronized (httpServletRequest) {
            Enumeration attribs = this.request.getHeaderNames();
            while (attribs.hasMoreElements() && retValue) {
                String parameterName = (String)attribs.nextElement();
                retValue = this.request.getHeader(parameterName).equals(otherRequest.getHeader(parameterName));
            }
        }
        return retValue;
    }

    @Override
    public String get(Object key) {
        return this.request.getHeader(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public String put(String key, String value) {
        this.response.setHeader(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            this.response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            list.add(this.request.getHeader((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

