/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFEncodedStringDecoder;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaIllustrator;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFUA;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFVT;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFX;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFXId;
import org.apache.tika.parser.xmp.JempboxExtractor;
import org.apache.tika.utils.StringUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PDMetadataExtractor {
    public static void extract(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            metadata.set(PDF.HAS_XMP, "false");
            return;
        }
        metadata.set(PDF.HAS_XMP, "true");
        Document dom = PDMetadataExtractor.loadDOM(pdMetadata, metadata, context);
        if (dom == null) {
            return;
        }
        XMPMetadata xmp = new XMPMetadata(dom);
        PDMetadataExtractor.extract(xmp, metadata, context);
    }

    public static void extract(XMPMetadata xmp, Metadata metadata, ParseContext context) {
        PDMetadataExtractor.extractBasic(xmp, metadata);
        PDMetadataExtractor.extractPDF(xmp, metadata);
        PDMetadataExtractor.extractDublin(xmp, metadata);
        JempboxExtractor.extractXMPMM((XMPMetadata)xmp, (Metadata)metadata);
        PDMetadataExtractor.extractPDFA(xmp, metadata);
        PDMetadataExtractor.extractPDFX(xmp, metadata);
        PDMetadataExtractor.extractPDFVT(xmp, metadata);
        PDMetadataExtractor.extractPDFUA(xmp, metadata);
        PDMetadataExtractor.extractIllustrator(xmp, metadata);
    }

    private static void extractIllustrator(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://ns.adobe.com/illustrator/1.0/", XMPSchemaIllustrator.class);
        XMPSchemaIllustrator schema = null;
        try {
            schema = (XMPSchemaIllustrator)xmp.getSchemaByClass(XMPSchemaIllustrator.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String type = schema.getType();
        if (!StringUtils.isBlank((String)type)) {
            metadata.set(PDF.ILLUSTRATOR_TYPE, type);
        }
    }

    private static void extractDublin(XMPMetadata xmp, Metadata metadata) {
        XMPSchemaDublinCore dcSchema = null;
        try {
            dcSchema = xmp.getDublinCoreSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dcSchema != null) {
            PDMetadataExtractor.extractMultilingualItems(metadata, TikaCoreProperties.DESCRIPTION, null, (XMPSchema)dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.CONTRIBUTOR, dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.CREATOR, dcSchema);
            PDMetadataExtractor.extractMultilingualItems(metadata, TikaCoreProperties.TITLE, null, (XMPSchema)dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.TYPE, dcSchema);
            PDMetadataExtractor.extractDublinCoreSimpleItem(metadata, TikaCoreProperties.IDENTIFIER, dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.LANGUAGE, dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.PUBLISHER, dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.RELATION, dcSchema);
            PDMetadataExtractor.extractDublinCoreSimpleItem(metadata, TikaCoreProperties.SOURCE, dcSchema);
            PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.SUBJECT, dcSchema);
        }
    }

    private static void extractPDFVT(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.npes.org/pdfvt/ns/id/", XMPSchemaPDFVT.class);
        XMPSchemaPDFVT schema = null;
        try {
            schema = (XMPSchemaPDFVT)xmp.getSchemaByClass(XMPSchemaPDFVT.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String version = schema.getPDFVTVersion();
        if (!StringUtils.isBlank((String)version)) {
            metadata.set(PDF.PDFVT_VERSION, version);
        }
        try {
            Calendar modified = schema.getPDFVTModified();
            metadata.set(PDF.PDFVT_MODIFIED, modified);
        }
        catch (IOException ex) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "bad date in vt modified");
        }
    }

    private static void extractPDFX(XMPMetadata xmp, Metadata metadata) {
        String version;
        xmp.addXMLNSMapping("http://www.npes.org/pdfx/ns/id/", XMPSchemaPDFXId.class);
        xmp.addXMLNSMapping("http://ns.adobe.com/pdfx/1.3/", XMPSchemaPDFX.class);
        try {
            XMPSchemaPDFXId XMPSchemaPDFXId2 = (XMPSchemaPDFXId)xmp.getSchemaByClass(XMPSchemaPDFXId.class);
            if (XMPSchemaPDFXId2 != null && !StringUtils.isBlank((String)(version = XMPSchemaPDFXId2.getPDFXVersion()))) {
                metadata.set(PDF.PDFXID_VERSION, version);
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        try {
            XMPSchemaPDFX XMPSchemaPDFX2 = (XMPSchemaPDFX)xmp.getSchemaByClass(XMPSchemaPDFX.class);
            if (XMPSchemaPDFX2 != null) {
                String conformance;
                version = XMPSchemaPDFX2.getPDFXVersion();
                if (!StringUtils.isBlank((String)version)) {
                    metadata.set(PDF.PDFX_VERSION, version);
                }
                if (!StringUtils.isBlank((String)(conformance = XMPSchemaPDFX2.getPDFXConformance()))) {
                    metadata.set(PDF.PDFX_CONFORMANCE, conformance);
                }
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
    }

    private static void extractPDFUA(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.aiim.org/pdfua/ns/id/", XMPSchemaPDFUA.class);
        XMPSchemaPDFUA schema = null;
        try {
            schema = (XMPSchemaPDFUA)xmp.getSchemaByClass(XMPSchemaPDFUA.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        try {
            Integer part = schema.getPart();
            if (schema.getPart() != null) {
                metadata.set(PDF.PDFUAID_PART, part.intValue());
            }
        }
        catch (NumberFormatException e) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "expected integer part");
        }
    }

    private static void extractPDFA(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
        XMPSchemaPDFAId schema = null;
        try {
            schema = (XMPSchemaPDFAId)xmp.getSchemaByClass(XMPSchemaPDFAId.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String partString = "UNKNOWN";
        try {
            Integer part = schema.getPart();
            if (part != null) {
                partString = Integer.toString(part);
                metadata.set(PDF.PDFAID_PART, part.intValue());
            }
        }
        catch (NumberFormatException e) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "expected integer part");
        }
        if (schema.getConformance() != null) {
            metadata.set(PDF.PDFAID_CONFORMANCE, schema.getConformance());
            String version = "A-" + partString + schema.getConformance().toLowerCase(Locale.ROOT);
            metadata.set(PDF.PDFA_VERSION, version);
        }
    }

    private static void extractPDF(XMPMetadata xmp, Metadata metadata) {
        if (xmp == null) {
            return;
        }
        XMPSchemaPDF pdf = null;
        try {
            pdf = xmp.getPDFSchema();
        }
        catch (IOException e) {
            return;
        }
        if (pdf == null) {
            return;
        }
        PDMetadataExtractor.setNotNull(PDF.PRODUCER, pdf.getProducer(), metadata);
        PDMetadataExtractor.setNotNull(Office.KEYWORDS, pdf.getKeywords(), metadata);
        PDMetadataExtractor.setNotNull(PDF.PDF_VERSION, pdf.getPDFVersion(), metadata);
    }

    private static void extractBasic(XMPMetadata xmp, Metadata metadata) {
        List advisories;
        if (xmp == null) {
            return;
        }
        XMPSchemaBasic basic = null;
        try {
            basic = xmp.getBasicSchema();
        }
        catch (IOException e) {
            return;
        }
        if (basic == null) {
            return;
        }
        PDMetadataExtractor.setNotNull(XMP.CREATOR_TOOL, basic.getCreatorTool(), metadata);
        PDMetadataExtractor.setNotNull(DublinCore.TITLE, basic.getTitle(), metadata);
        PDMetadataExtractor.setNotNull(XMP.ABOUT, basic.getAbout(), metadata);
        PDMetadataExtractor.setNotNull(XMP.LABEL, basic.getLabel(), metadata);
        try {
            PDMetadataExtractor.setNotNull(XMP.CREATE_DATE, basic.getCreateDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            PDMetadataExtractor.setNotNull(XMP.MODIFY_DATE, basic.getModifyDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            PDMetadataExtractor.setNotNull(XMP.METADATA_DATE, basic.getMetadataDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        List identifiers = basic.getIdentifiers();
        if (identifiers != null) {
            for (String identifier : identifiers) {
                metadata.add(XMP.IDENTIFIER, identifier);
            }
        }
        if ((advisories = basic.getAdvisories()) != null) {
            for (String advisory : advisories) {
                metadata.add(XMP.ADVISORY, advisory);
            }
        }
        PDMetadataExtractor.setNotNull(XMP.NICKNAME, basic.getNickname(), metadata);
        try {
            PDMetadataExtractor.setNotNull(XMP.RATING, basic.getRating(), metadata);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void setNotNull(Property property, String value, Metadata metadata) {
        if (metadata.get(property) == null && value != null && !value.isBlank()) {
            metadata.set(property, PDMetadataExtractor.decode(value));
        }
    }

    private static void setNotNull(Property property, Calendar value, Metadata metadata) {
        if (metadata.get(property) == null && value != null) {
            metadata.set(property, value);
        }
    }

    private static void setNotNull(Property property, Integer value, Metadata metadata) {
        if (metadata.get(property) == null && value != null) {
            metadata.set(property, value.intValue());
        }
    }

    static void addNotNull(Property property, String value, Metadata metadata) {
        if (!StringUtils.isBlank((String)value)) {
            metadata.add(property, value);
        }
    }

    static List<String> getXMPBagOrSeqList(XMPSchema schema, String name) {
        List ret = schema.getBagList(name);
        if (ret == null) {
            ret = schema.getSequenceList(name);
        }
        return ret;
    }

    private static void extractMultilingualItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchema schema) {
        if (schema == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                PDMetadataExtractor.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        for (String lang : schema.getLanguagePropertyLanguages(property.getName())) {
            String value = schema.getLanguageProperty(property.getName(), lang);
            if (value == null || value.length() <= 0 || pdfBoxBaseline != null && value.equals(pdfBoxBaseline)) continue;
            PDMetadataExtractor.addMetadata(metadata, property, value);
            if (property.isMultiValuePermitted()) continue;
            return;
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            if (!property.isMultiValuePermitted() && metadata.get(property) != null) {
                return;
            }
            PDMetadataExtractor.addMetadata(metadata, property, pdfBoxBaseline);
        }
    }

    private static void extractDublinCoreListItems(Metadata metadata, Property property, XMPSchemaDublinCore dc) {
        if (dc == null) {
            return;
        }
        List<String> items = PDMetadataExtractor.getXMPBagOrSeqList((XMPSchema)dc, property.getName());
        if (items == null) {
            return;
        }
        for (String item : items) {
            PDMetadataExtractor.addMetadata(metadata, property, item);
        }
    }

    private static void extractDublinCoreSimpleItem(Metadata metadata, Property property, XMPSchemaDublinCore dc) {
        if (dc == null) {
            return;
        }
        String textProperty = dc.getTextProperty(property.getName());
        PDMetadataExtractor.addMetadata(metadata, property, textProperty);
    }

    static void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            String decoded = PDMetadataExtractor.decode(value);
            if (StringUtils.isBlank((String)decoded)) {
                return;
            }
            if (property.isMultiValuePermitted() || metadata.get(property) == null) {
                for (String v : metadata.getValues(property)) {
                    if (!v.equals(decoded)) continue;
                    return;
                }
                metadata.add(property, decoded);
            }
        }
    }

    static void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            String decoded = PDMetadataExtractor.decode(value);
            if (StringUtils.isBlank((String)decoded)) {
                return;
            }
            for (String v : metadata.getValues(name)) {
                if (!v.equals(decoded)) continue;
                return;
            }
            metadata.add(name, decoded);
        }
    }

    static String decode(String value) {
        if (PDFEncodedStringDecoder.shouldDecode(value)) {
            PDFEncodedStringDecoder d = new PDFEncodedStringDecoder();
            return d.decode(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDOM(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            return null;
        }
        InputStream is = null;
        try {
            try {
                is = pdMetadata.exportXMPMetadata();
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                Document document = null;
                IOUtils.closeQuietly((InputStream)is);
                return document;
            }
            Document e = XMLReaderUtils.buildDOM((InputStream)is, (ParseContext)context);
            return e;
        }
        catch (IOException | TikaException | SAXException e) {
            EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)metadata);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    static void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }

    static void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (Object v : ((COSArray)value).toList()) {
                PDMetadataExtractor.addMetadata(metadata, name, (COSBase)v);
            }
        } else if (value instanceof COSString) {
            PDMetadataExtractor.addMetadata(metadata, name, ((COSString)value).getString());
        } else if (value != null && !(value instanceof COSDictionary)) {
            PDMetadataExtractor.addMetadata(metadata, name, value.toString());
        }
    }
}

