/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.upload.services;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileCleaner;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.annotations.Scope;
import org.apache.tapestry.ioc.services.PerthreadManager;
import org.apache.tapestry.ioc.services.RegistryShutdownHub;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.apache.tapestry.ioc.services.ThreadCleanupListener;
import org.apache.tapestry.services.HttpServletRequestFilter;
import org.apache.tapestry.services.LibraryMapping;
import org.apache.tapestry.upload.internal.services.MultipartDecoderImpl;
import org.apache.tapestry.upload.internal.services.MultipartServletRequestFilter;
import org.apache.tapestry.upload.services.MultipartDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadModule {
    private static final AtomicBoolean _needToAddShutdownListener = new AtomicBoolean(true);

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("core", "org.apache.tapestry.upload"));
    }

    @Scope(value="perthread")
    public static synchronized MultipartDecoder buildMultipartDecoder(PerthreadManager perthreadManager, RegistryShutdownHub shutdownHub, ObjectLocator locator) {
        MultipartDecoderImpl multipartDecoder = (MultipartDecoderImpl)locator.autobuild(MultipartDecoderImpl.class);
        perthreadManager.addThreadCleanupListener((ThreadCleanupListener)multipartDecoder);
        if (_needToAddShutdownListener.getAndSet(false)) {
            shutdownHub.addRegistryShutdownListener(new RegistryShutdownListener(){

                public void registryDidShutdown() {
                    FileCleaner.exitWhenFinished();
                }
            });
        }
        return multipartDecoder;
    }

    public static void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, MultipartDecoder multipartDecoder) {
        configuration.add("MultipartFilter", (Object)new MultipartServletRequestFilter(multipartDecoder), new String[]{"after:IgnoredPaths"});
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"upload.repository-threshold", (Object)Integer.toString(10240));
        configuration.add((Object)"upload.repository-location", (Object)System.getProperty("java.io.tmpdir"));
        configuration.add((Object)"upload.requestsize-max", (Object)"-1");
        configuration.add((Object)"upload.filesize-max", (Object)"-1");
    }
}

