/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InheritanceSearch;
import org.apache.tapestry5.ioc.util.UtilMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrategyRegistry<A> {
    private final Class<A> adapterType;
    private final boolean allowNonMatch;
    private final Map<Class, A> registrations = CollectionFactory.newMap();
    private final Map<Class, A> cache = CollectionFactory.newConcurrentMap();
    private final Map<Class, Boolean> unmatched = CollectionFactory.newConcurrentMap();

    private StrategyRegistry(Class<A> adapterType, Map<Class, A> registrations, boolean allowNonMatch) {
        this.adapterType = adapterType;
        this.allowNonMatch = allowNonMatch;
        this.registrations.putAll(registrations);
    }

    public static <A> StrategyRegistry<A> newInstance(Class<A> adapterType, Map<Class, A> registrations) {
        return StrategyRegistry.newInstance(adapterType, registrations, false);
    }

    public static <A> StrategyRegistry<A> newInstance(Class<A> adapterType, Map<Class, A> registrations, boolean allowNonMatch) {
        return new StrategyRegistry<A>(adapterType, registrations, allowNonMatch);
    }

    public void clearCache() {
        this.cache.clear();
        this.unmatched.clear();
    }

    public Class<A> getAdapterType() {
        return this.adapterType;
    }

    public A getByInstance(Object value) {
        return this.get(value == null ? Void.TYPE : value.getClass());
    }

    public A get(Class type) {
        A result = this.cache.get(type);
        if (result != null) {
            return result;
        }
        if (this.unmatched.containsKey(type)) {
            return null;
        }
        result = this.findMatch(type);
        if (result != null) {
            this.cache.put(type, result);
        } else {
            this.unmatched.put(type, true);
        }
        return result;
    }

    private A findMatch(Class type) {
        for (Class t : new InheritanceSearch(type)) {
            A result = this.registrations.get(t);
            if (result == null) continue;
            return result;
        }
        if (this.allowNonMatch) {
            return null;
        }
        List<String> names = CollectionFactory.newList();
        for (Class t : this.registrations.keySet()) {
            names.add(t.getName());
        }
        throw new IllegalArgumentException(UtilMessages.noStrategyAdapter(type, this.adapterType, names));
    }

    public Collection<Class> getTypes() {
        return CollectionFactory.newList(this.registrations.keySet());
    }

    public String toString() {
        return String.format("StrategyRegistry[%s]", this.adapterType.getName());
    }
}

