/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.ConstantInjector;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.util.BodyBuilder;
import org.apache.tapestry5.ioc.util.IdAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantInjectorImpl
implements ConstantInjector {
    private final ClassFab classFab;
    private final IdAllocator allocator = new IdAllocator("_");
    private final List<InjectedValue> injections = CollectionFactory.newList();
    private final Map<Object, String> instanceToFieldName = CollectionFactory.newMap();

    public ConstantInjectorImpl(ClassFab classFab) {
        this.classFab = classFab;
    }

    @Override
    public <T> String inject(Class<T> type, T instance) {
        String fieldName = this.instanceToFieldName.get(instance);
        if (fieldName == null) {
            fieldName = this.allocator.allocateId(type.getSimpleName().toLowerCase());
            this.injections.add(new InjectedValue(type, instance, fieldName));
            this.classFab.addField(fieldName, 18, type);
            this.instanceToFieldName.put(instance, fieldName);
        }
        return fieldName;
    }

    void implementConstructor() {
        int count = this.injections.size();
        Class[] types = new Class[count];
        BodyBuilder builder = new BodyBuilder().begin();
        for (int i = 0; i < count; ++i) {
            InjectedValue injected = this.injections.get(i);
            types[i] = injected.type;
            builder.addln("%s = $%d;", injected.fieldName, i + 1);
        }
        builder.end();
        this.classFab.addConstructor(types, null, builder.toString());
    }

    public Object[] getParameters() {
        int count = this.injections.size();
        Object[] values = new Object[count];
        for (int i = 0; i < count; ++i) {
            InjectedValue injected = this.injections.get(i);
            values[i] = injected.value;
        }
        return values;
    }

    private class InjectedValue {
        final Class type;
        final Object value;
        final String fieldName;

        private InjectedValue(Class type, Object value, String fieldName) {
            this.type = type;
            this.value = value;
            this.fieldName = fieldName;
        }
    }
}

