/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerthreadManagerImpl
implements PerthreadManager {
    private static final String LISTENERS_KEY = "PerthreadManager.listenerList";
    private final Logger logger;
    private final MapHolder holder = new MapHolder();

    public PerthreadManagerImpl(Logger logger) {
        this.logger = logger;
    }

    private synchronized Map getPerthreadMap() {
        return (Map)this.holder.get();
    }

    private List<ThreadCleanupListener> getListeners() {
        List<ThreadCleanupListener> result = (List<ThreadCleanupListener>)this.get(LISTENERS_KEY);
        if (result == null) {
            result = CollectionFactory.newList();
            this.put(LISTENERS_KEY, result);
        }
        return result;
    }

    @Override
    public void addThreadCleanupListener(ThreadCleanupListener listener) {
        this.getListeners().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        List<ThreadCleanupListener> listeners = this.getListeners();
        this.put(LISTENERS_KEY, null);
        for (ThreadCleanupListener listener : listeners) {
            try {
                listener.threadDidCleanup();
            }
            catch (Exception ex) {
                this.logger.warn(ServiceMessages.threadCleanupError(listener, ex), (Throwable)ex);
            }
        }
        PerthreadManagerImpl perthreadManagerImpl = this;
        synchronized (perthreadManagerImpl) {
            this.holder.remove();
        }
    }

    @Override
    public void put(Object key, Object value) {
        this.getPerthreadMap().put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.getPerthreadMap().get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapHolder
    extends ThreadLocal<Map> {
        private MapHolder() {
        }

        @Override
        protected Map initialValue() {
            return CollectionFactory.newMap();
        }
    }
}

