/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.internal.services.MethodInfo;
import org.apache.tapestry5.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvocation
implements Invocation {
    private final MethodInfo methodInfo;
    private final Method method;
    private Throwable thrown;
    private Object result;
    private int adviceIndex = 0;

    protected AbstractInvocation(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.method = methodInfo.getMethod();
    }

    public String toString() {
        return String.format("Invocation[%s]", this.method);
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public Class getResultType() {
        return this.method.getReturnType();
    }

    @Override
    public int getParameterCount() {
        return this.method.getParameterTypes().length;
    }

    @Override
    public Class getParameterType(int index) {
        return this.method.getParameterTypes()[index];
    }

    @Override
    public boolean isFail() {
        return this.thrown != null;
    }

    @Override
    public <T extends Throwable> T getThrown(Class<T> throwableClass) {
        Defense.notNull(throwableClass, "throwableClass");
        if (throwableClass.isInstance(this.thrown)) {
            return (T)((Throwable)throwableClass.cast(this.thrown));
        }
        return null;
    }

    @Override
    public void overrideThrown(Exception thrown) {
        Defense.notNull(thrown, "thrown");
        for (Class<?> t : this.method.getExceptionTypes()) {
            if (!t.isInstance(thrown)) continue;
            this.thrown = thrown;
            return;
        }
        throw new IllegalArgumentException(String.format("Exception %s is not a declared exception of method %s.", thrown.getClass().getName(), this.method));
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void overrideResult(Object newResult) {
        this.result = newResult;
        this.thrown = null;
    }

    @Override
    public void proceed() {
        if (this.adviceIndex >= this.methodInfo.getAdviceCount()) {
            this.invokeDelegateMethod();
            return;
        }
        this.methodInfo.getAdvice(this.adviceIndex++).advise(this);
    }

    protected abstract void invokeDelegateMethod();
}

