/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.OperationException;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.Stack;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTrackerImpl
implements OperationTracker {
    private final Logger logger;
    private final Stack<String> operations = CollectionFactory.newStack();
    private boolean logged;

    public OperationTrackerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void run(String description, final Runnable operation) {
        Defense.notBlank(description, "description");
        Defense.notNull(operation, "operation");
        this.invoke(description, new Invokable<Void>(){

            @Override
            public Void invoke() {
                operation.run();
                return null;
            }
        });
    }

    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        Defense.notBlank(description, "description");
        Defense.notNull(operation, "operation");
        this.operations.push(description);
        try {
            T t = operation.invoke();
            return t;
        }
        catch (RuntimeException ex) {
            if (!this.logged) {
                this.logger.error(InternalUtils.toMessage(ex));
                this.logger.error("Operations trace:");
                Object[] snapshot = this.operations.getSnapshot();
                String[] trace = new String[snapshot.length];
                for (int i = 0; i < snapshot.length; ++i) {
                    trace[i] = snapshot[i].toString();
                    this.logger.error(String.format("[%2d] %s", i + 1, trace[i]));
                }
                this.logged = true;
                throw new OperationException(ex, trace);
            }
            throw ex;
        }
        finally {
            this.operations.pop();
            if (this.operations.isEmpty()) {
                this.logged = false;
            }
        }
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

