/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassFabUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceSearch
implements Iterator<Class>,
Iterable<Class> {
    private Class _searchClass;
    private final Set<Class> _addedInterfaces = CollectionFactory.newSet();
    private final LinkedList<Class> _interfaceQueue = CollectionFactory.newLinkedList();
    private State _state;

    public InheritanceSearch(Class searchClass) {
        this._searchClass = searchClass;
        this.queueInterfaces(searchClass);
        this._state = searchClass == Object.class ? State.INTERFACE : State.CLASS;
    }

    private void queueInterfaces(Class searchClass) {
        for (Class<?> intf : searchClass.getInterfaces()) {
            if (this._addedInterfaces.contains(intf)) continue;
            this._interfaceQueue.addLast(intf);
            this._addedInterfaces.add(intf);
        }
    }

    @Override
    public Iterator<Class> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._state != State.DONE;
    }

    @Override
    public Class next() {
        switch (this._state) {
            case CLASS: {
                Class result = this._searchClass;
                this._searchClass = this.parentOf(this._searchClass);
                if (this._searchClass == null) {
                    this._state = State.INTERFACE;
                } else {
                    this.queueInterfaces(this._searchClass);
                }
                return result;
            }
            case INTERFACE: {
                if (this._interfaceQueue.isEmpty()) {
                    this._state = State.DONE;
                    return Object.class;
                }
                Class intf = this._interfaceQueue.removeFirst();
                this.queueInterfaces(intf);
                return intf;
            }
        }
        throw new IllegalStateException();
    }

    private Class parentOf(Class clazz) {
        Class parent;
        if (clazz != Void.TYPE && clazz.isPrimitive()) {
            return ClassFabUtils.getWrapperType(clazz);
        }
        if (clazz.isArray() && clazz != Object[].class) {
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            if (!componentType.isPrimitive()) {
                return Object[].class;
            }
        }
        return (parent = clazz.getSuperclass()) != Object.class ? parent : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CLASS,
        INTERFACE,
        DONE;

    }
}

