/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tapestry.ioc.internal.util.Invokable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentBarrier {
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private final ThreadBoolean _threadHasReadLock = new ThreadBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withRead(Invokable<T> invokable) {
        boolean readLockedAtEntry = (Boolean)this._threadHasReadLock.get();
        if (!readLockedAtEntry) {
            this._lock.readLock().lock();
            this._threadHasReadLock.set(true);
        }
        try {
            T t = invokable.invoke();
            return t;
        }
        finally {
            if (!readLockedAtEntry) {
                this._lock.readLock().unlock();
                this._threadHasReadLock.remove();
            }
        }
    }

    public void withRead(final Runnable runnable) {
        Invokable<Void> invokable = new Invokable<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        };
        this.withRead(invokable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withWrite(Invokable<T> invokable) {
        boolean readLockedAtEntry = this.releaseReadLock();
        this._lock.writeLock().lock();
        try {
            T t = invokable.invoke();
            return t;
        }
        finally {
            this._lock.writeLock().unlock();
            this.restoreReadLock(readLockedAtEntry);
        }
    }

    private boolean releaseReadLock() {
        boolean readLockedAtEntry = (Boolean)this._threadHasReadLock.get();
        if (readLockedAtEntry) {
            this._lock.readLock().unlock();
            this._threadHasReadLock.set(false);
        }
        return readLockedAtEntry;
    }

    private void restoreReadLock(boolean readLockedAtEntry) {
        if (readLockedAtEntry) {
            this._lock.readLock().lock();
            this._threadHasReadLock.set(true);
        } else {
            this._threadHasReadLock.remove();
        }
    }

    public void withWrite(final Runnable runnable) {
        Invokable<Void> invokable = new Invokable<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        };
        this.withWrite(invokable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWithWrite(Runnable runnable, long timeout, TimeUnit timeoutUnit) {
        boolean readLockedAtEntry = this.releaseReadLock();
        boolean obtainedLock = false;
        try {
            try {
                obtainedLock = this._lock.writeLock().tryLock(timeout, timeoutUnit);
                if (obtainedLock) {
                    runnable.run();
                }
            }
            catch (InterruptedException e) {
                obtainedLock = false;
            }
            finally {
                if (obtainedLock) {
                    this._lock.writeLock().unlock();
                }
            }
        }
        finally {
            this.restoreReadLock(readLockedAtEntry);
        }
        return obtainedLock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadBoolean
    extends ThreadLocal<Boolean> {
        private ThreadBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

