/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import org.apache.tapestry.ioc.AnnotationProvider;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.annotations.IntermediateType;
import org.apache.tapestry.ioc.annotations.Value;
import org.apache.tapestry.ioc.services.Builtin;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueObjectProvider
implements ObjectProvider {
    private final SymbolSource _symbolSource;
    private final TypeCoercer _typeCoercer;

    public ValueObjectProvider(@Builtin SymbolSource symbolSource, @Builtin TypeCoercer typeCoercer) {
        this._symbolSource = symbolSource;
        this._typeCoercer = typeCoercer;
    }

    @Override
    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        Value annotation = annotationProvider.getAnnotation(Value.class);
        if (annotation == null) {
            return null;
        }
        String value = annotation.value();
        String expanded = this._symbolSource.expandSymbols(value);
        IntermediateType intermediate = annotationProvider.getAnnotation(IntermediateType.class);
        if (intermediate != null) {
            expanded = this._typeCoercer.coerce(expanded, intermediate.value());
        }
        return this._typeCoercer.coerce(expanded, objectType);
    }
}

