/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ServiceActivity;
import org.apache.tapestry.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry.ioc.services.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceActivityTrackerImpl
implements ServiceActivityScoreboard,
ServiceActivityTracker {
    private final Map<String, MutableServiceActivity> _serviceIdToServiceStatus = new TreeMap<String, MutableServiceActivity>();

    @Override
    public synchronized List<ServiceActivity> getServiceActivity() {
        List<ServiceActivity> result = CollectionFactory.newList();
        result.addAll(this._serviceIdToServiceStatus.values());
        return result;
    }

    void startup() {
    }

    void shutdown() {
    }

    @Override
    public synchronized void define(ServiceDef serviceDef, Status initialStatus) {
        this._serviceIdToServiceStatus.put(serviceDef.getServiceId(), new MutableServiceActivity(serviceDef, initialStatus));
    }

    @Override
    public synchronized void setStatus(String serviceId, Status status) {
        this._serviceIdToServiceStatus.get(serviceId).setStatus(status);
    }

    public static class MutableServiceActivity
    implements ServiceActivity {
        private final ServiceDef _serviceDef;
        private Status _status;

        public MutableServiceActivity(ServiceDef serviceDef, Status status) {
            this._serviceDef = serviceDef;
            this._status = status;
        }

        public String getServiceId() {
            return this._serviceDef.getServiceId();
        }

        public Class getServiceInterface() {
            return this._serviceDef.getServiceInterface();
        }

        public String getScope() {
            return this._serviceDef.getServiceScope();
        }

        public synchronized Status getStatus() {
            return this._status;
        }

        synchronized void setStatus(Status status) {
            this._status = status;
        }
    }
}

