/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.ioc.LoggerSource;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.annotations.SubModule;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.internal.DefaultModuleDefImpl;
import org.apache.tapestry.ioc.internal.LoggerSourceImpl;
import org.apache.tapestry.ioc.internal.RegistryImpl;
import org.apache.tapestry.ioc.internal.RegistryWrapper;
import org.apache.tapestry.ioc.internal.services.ClassFactoryImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.TapestryIOCModule;
import org.slf4j.Logger;

public final class RegistryBuilder {
    private final OneShotLock _lock = new OneShotLock();
    final List<ModuleDef> _modules = CollectionFactory.newList();
    private final ClassLoader _classLoader;
    private final Logger _logger;
    private final LoggerSource _loggerSource;
    private final ClassFactory _classFactory;
    private final Set<Class> _addedModuleClasses = CollectionFactory.newSet();

    public RegistryBuilder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public RegistryBuilder(ClassLoader classLoader) {
        this(classLoader, new LoggerSourceImpl());
    }

    public RegistryBuilder(ClassLoader classLoader, LoggerSource loggerSource) {
        this._classLoader = classLoader;
        this._loggerSource = loggerSource;
        this._logger = loggerSource.getLogger(RegistryBuilder.class);
        Logger classFactoryLogger = loggerSource.getLogger(TapestryIOCModule.class.getName() + ".ClassFactory");
        this._classFactory = new ClassFactoryImpl(this._classLoader, classFactoryLogger);
        this.add(TapestryIOCModule.class);
    }

    public void add(ModuleDef moduleDef) {
        this._lock.check();
        this._modules.add(moduleDef);
    }

    public void add(Class ... moduleBuilderClasses) {
        this._lock.check();
        List queue = CollectionFactory.newList(Arrays.asList(moduleBuilderClasses));
        while (!queue.isEmpty()) {
            Class c = (Class)queue.remove(0);
            if (this._addedModuleClasses.contains(c)) continue;
            this._addedModuleClasses.add(c);
            DefaultModuleDefImpl def = new DefaultModuleDefImpl(c, this._logger, this._classFactory);
            this.add(def);
            SubModule annotation = c.getAnnotation(SubModule.class);
            if (annotation == null) continue;
            queue.addAll(Arrays.asList(annotation.value()));
        }
    }

    public void add(String classname) {
        this._lock.check();
        try {
            Class<?> builderClass = Class.forName(classname, true, this._classLoader);
            this.add(builderClass);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Registry build() {
        this._lock.lock();
        RegistryImpl registry = new RegistryImpl(this._modules, this._classFactory, this._loggerSource);
        return new RegistryWrapper(registry);
    }

    public ClassLoader getClassLoader() {
        this._lock.check();
        return this._classLoader;
    }

    public Logger getLogger() {
        this._lock.check();
        return this._logger;
    }
}

