/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic.asm.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tapestry5.internal.plastic.asm.ClassReader;
import org.apache.tapestry5.internal.plastic.asm.ClassWriter;
import org.apache.tapestry5.internal.plastic.asm.commons.Remapper;
import org.apache.tapestry5.internal.plastic.asm.commons.SimpleRemapper;
import org.apache.tapestry5.internal.plastic.asm.optimizer.ClassConstantsCollector;
import org.apache.tapestry5.internal.plastic.asm.optimizer.ClassOptimizer;
import org.apache.tapestry5.internal.plastic.asm.optimizer.Constant;
import org.apache.tapestry5.internal.plastic.asm.optimizer.ConstantPool;

public class Shrinker {
    static final Properties MAPPING = new Properties();

    public static void main(String[] args) throws IOException {
        int n = args.length - 1;
        for (int i = 0; i < n - 1; ++i) {
            MAPPING.load(new FileInputStream(args[i]));
        }
        final HashSet<Object> unused = new HashSet<Object>(MAPPING.keySet());
        File f = new File(args[n - 1]);
        File d = new File(args[n]);
        Shrinker.optimize(f, d, new SimpleRemapper(MAPPING){

            public String map(String key) {
                String s = super.map(key);
                if (s != null) {
                    unused.remove(key);
                }
                return s;
            }
        });
        for (String string : unused) {
            if (string.endsWith("/remove")) continue;
            System.out.println("INFO: unused mapping " + string);
        }
    }

    static void optimize(File f, File d, Remapper remapper) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Shrinker.optimize(files[i], d, remapper);
            }
        } else if (f.getName().endsWith(".class")) {
            ConstantPool cp = new ConstantPool();
            ClassReader cr = new ClassReader(new FileInputStream(f));
            ClassWriter cw = new ClassWriter(0);
            ClassConstantsCollector ccc = new ClassConstantsCollector(cw, cp);
            ClassOptimizer co = new ClassOptimizer(ccc, remapper);
            cr.accept(co, 2);
            TreeSet constants = new TreeSet(new ConstantComparator());
            constants.addAll(cp.values());
            cr = new ClassReader(cw.toByteArray());
            cw = new ClassWriter(0);
            for (Constant c : constants) {
                c.write(cw);
            }
            cr.accept(cw, 2);
            if (MAPPING.getProperty(cr.getClassName() + "/remove") != null) {
                return;
            }
            String n = remapper.mapType(cr.getClassName());
            File g = new File(d, n + ".class");
            if (!g.exists() || g.lastModified() < f.lastModified()) {
                g.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(g);
                ((OutputStream)os).write(cw.toByteArray());
                ((OutputStream)os).close();
            }
        }
    }

    static class ConstantComparator
    implements Comparator {
        ConstantComparator() {
        }

        public int compare(Object o1, Object o2) {
            Constant c1 = (Constant)o1;
            Constant c2 = (Constant)o2;
            int d = ConstantComparator.getSort(c1) - ConstantComparator.getSort(c2);
            if (d == 0) {
                switch (c1.type) {
                    case 'I': {
                        return new Integer(c1.intVal).compareTo(new Integer(c2.intVal));
                    }
                    case 'J': {
                        return new Long(c1.longVal).compareTo(new Long(c2.longVal));
                    }
                    case 'F': {
                        return new Float(c1.floatVal).compareTo(new Float(c2.floatVal));
                    }
                    case 'D': {
                        return new Double(c1.doubleVal).compareTo(new Double(c2.doubleVal));
                    }
                    case 'C': 
                    case 'S': 
                    case 's': {
                        return c1.strVal1.compareTo(c2.strVal1);
                    }
                    case 'T': {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0) break;
                        d = c1.strVal2.compareTo(c2.strVal2);
                        break;
                    }
                    default: {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0 || (d = c1.strVal2.compareTo(c2.strVal2)) != 0) break;
                        d = c1.strVal3.compareTo(c2.strVal3);
                    }
                }
            }
            return d;
        }

        private static int getSort(Constant c) {
            switch (c.type) {
                case 'I': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'F': {
                    return 2;
                }
                case 'D': {
                    return 3;
                }
                case 's': {
                    return 4;
                }
                case 'S': {
                    return 5;
                }
                case 'C': {
                    return 6;
                }
                case 'T': {
                    return 7;
                }
                case 'G': {
                    return 8;
                }
                case 'M': {
                    return 9;
                }
            }
            return 10;
        }
    }
}

