/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Modifier;
import org.apache.tapestry5.internal.plastic.FieldHandleImpl;
import org.apache.tapestry5.internal.plastic.FieldState;
import org.apache.tapestry5.internal.plastic.InstructionBuilderImpl;
import org.apache.tapestry5.internal.plastic.PlasticClassHandleShim;
import org.apache.tapestry5.internal.plastic.PlasticClassImpl;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PlasticMember;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.TransformationOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlasticFieldImpl
extends PlasticMember
implements PlasticField,
Comparable<PlasticFieldImpl> {
    private final FieldNode node;
    private final String typeName;
    private Object tag;
    private FieldHandleImpl handle;
    private MethodNode getAccess;
    private MethodNode setAccess;
    private FieldState state = FieldState.INITIAL;
    private int fieldIndex = -1;

    public PlasticFieldImpl(PlasticClassImpl plasticClass, FieldNode node) {
        super(plasticClass, node.visibleAnnotations);
        this.node = node;
        this.typeName = Type.getType(node.desc).getClassName();
    }

    public String toString() {
        return String.format("PlasticField[%s %s %s (in class %s)]", Modifier.toString(this.node.access), this.typeName, this.node.name, this.plasticClass.className);
    }

    @Override
    public String getGenericSignature() {
        return this.node.signature;
    }

    @Override
    public int getModifiers() {
        return this.node.access;
    }

    @Override
    public int compareTo(PlasticFieldImpl o) {
        return this.node.name.compareTo(o.node.name);
    }

    @Override
    public PlasticClass getPlasticClass() {
        this.plasticClass.check();
        return this.plasticClass;
    }

    @Override
    public FieldHandle getHandle() {
        this.plasticClass.check();
        if (this.handle == null) {
            this.fieldIndex = this.plasticClass.nextFieldIndex++;
            this.handle = new FieldHandleImpl(this.plasticClass.className, this.node.name, this.fieldIndex);
            this.plasticClass.shimFields.add(this);
        }
        return this.handle;
    }

    @Override
    public PlasticField claim(Object tag) {
        assert (tag != null);
        this.plasticClass.check();
        if (this.tag != null) {
            throw new IllegalStateException(String.format("Field %s of class %s can not be claimed by %s as it is already claimed by %s.", this.node.name, this.plasticClass.className, tag, this.tag));
        }
        this.tag = tag;
        this.plasticClass.unclaimedFields = null;
        return this;
    }

    @Override
    public boolean isClaimed() {
        this.plasticClass.check();
        return this.tag != null;
    }

    @Override
    public String getName() {
        this.plasticClass.check();
        return this.node.name;
    }

    @Override
    public String getTypeName() {
        this.plasticClass.check();
        return this.typeName;
    }

    private void verifyInitialState(String operation) {
        if (this.state != FieldState.INITIAL) {
            throw new IllegalStateException(String.format("Unable to %s field %s of class %s, as it already %s.", operation, this.node.name, this.plasticClass.className, this.state.description));
        }
    }

    @Override
    public PlasticField inject(Object value) {
        this.plasticClass.check();
        this.verifyInitialState("inject a value into");
        assert (value != null);
        this.plasticClass.initializeFieldFromStaticContext(this.node.name, this.typeName, value);
        this.makeReadOnly();
        this.state = FieldState.INJECTED;
        return this;
    }

    @Override
    public PlasticField injectComputed(ComputedValue<?> computedValue) {
        this.plasticClass.check();
        this.verifyInitialState("inject a computed value into");
        assert (computedValue != null);
        this.initializeComputedField(computedValue);
        this.makeReadOnly();
        this.state = FieldState.INJECTED;
        return this;
    }

    private void initializeComputedField(ComputedValue<?> computedValue) {
        int index = this.plasticClass.staticContext.store(computedValue);
        this.plasticClass.constructorBuilder.loadThis();
        this.plasticClass.constructorBuilder.loadArgument(0).loadConstant(index);
        this.plasticClass.constructorBuilder.invoke(PlasticClassImpl.STATIC_CONTEXT_GET_METHOD).checkcast(ComputedValue.class);
        this.plasticClass.constructorBuilder.loadArgument(1);
        this.plasticClass.constructorBuilder.invoke(PlasticClassImpl.COMPUTED_VALUE_GET_METHOD).castOrUnbox(this.typeName);
        this.plasticClass.constructorBuilder.putField(this.plasticClass.className, this.node.name, this.typeName);
    }

    @Override
    public PlasticField injectFromInstanceContext() {
        this.plasticClass.check();
        this.verifyInitialState("inject instance context value into");
        this.plasticClass.constructorBuilder.loadThis();
        this.plasticClass.constructorBuilder.loadArgument(1);
        this.plasticClass.constructorBuilder.loadConstant(this.typeName);
        this.plasticClass.constructorBuilder.invokeStatic(PlasticInternalUtils.class, Object.class, "getFromInstanceContext", InstanceContext.class, String.class).castOrUnbox(this.typeName);
        this.plasticClass.constructorBuilder.putField(this.plasticClass.className, this.node.name, this.typeName);
        this.makeReadOnly();
        this.state = FieldState.INJECTED;
        return this;
    }

    @Override
    public <F> PlasticField setConduit(FieldConduit<F> conduit) {
        assert (conduit != null);
        this.plasticClass.check();
        this.verifyInitialState("set the FieldConduit for");
        String conduitFieldName = this.plasticClass.createAndInitializeFieldFromStaticContext(this.node.name + "_FieldConduit", FieldConduit.class.getName(), conduit);
        this.replaceFieldReadAccess(conduitFieldName);
        this.replaceFieldWriteAccess(conduitFieldName);
        this.state = FieldState.CONDUIT;
        return this;
    }

    @Override
    public <F> PlasticField setComputedConduit(ComputedValue<FieldConduit<F>> computedConduit) {
        assert (computedConduit != null);
        this.plasticClass.check();
        this.verifyInitialState("set the computed FieldConduit for");
        PlasticField conduitField = this.plasticClass.introduceField(FieldConduit.class, this.node.name + "_FieldConduit").injectComputed(computedConduit);
        this.replaceFieldReadAccess(conduitField.getName());
        this.replaceFieldWriteAccess(conduitField.getName());
        this.state = FieldState.CONDUIT;
        return this;
    }

    @Override
    public PlasticField createAccessors(PropertyAccessType accessType) {
        this.plasticClass.check();
        return this.createAccessors(accessType, PlasticInternalUtils.toPropertyName(this.node.name));
    }

    @Override
    public PlasticField createAccessors(PropertyAccessType accessType, String propertyName) {
        String signature;
        this.plasticClass.check();
        assert (accessType != null);
        assert (PlasticInternalUtils.isNonBlank(propertyName));
        String capitalized = PlasticInternalUtils.capitalize(propertyName);
        if (accessType != PropertyAccessType.WRITE_ONLY) {
            signature = this.node.signature == null ? null : "()" + this.node.signature;
            this.introduceAccessorMethod(this.getTypeName(), "get" + capitalized, null, signature, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().getField(PlasticFieldImpl.this).returnResult();
                }
            });
        }
        if (accessType != PropertyAccessType.READ_ONLY) {
            signature = this.node.signature == null ? null : "(" + this.node.signature + ")V";
            this.introduceAccessorMethod("void", "set" + capitalized, new String[]{this.getTypeName()}, signature, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().loadArgument(0);
                    builder.putField(PlasticFieldImpl.this.plasticClass.className, ((PlasticFieldImpl)PlasticFieldImpl.this).node.name, PlasticFieldImpl.this.getTypeName());
                    builder.returnResult();
                }
            });
        }
        return this;
    }

    private void introduceAccessorMethod(String returnType, String name, String[] parameterTypes, String signature, InstructionBuilderCallback callback) {
        MethodDescription description = new MethodDescription(1, returnType, name, parameterTypes, signature, null);
        String desc = this.plasticClass.nameCache.toDesc(description);
        if (this.plasticClass.inheritanceData.isImplemented(name, desc)) {
            throw new IllegalArgumentException(String.format("Unable to create new accessor method %s on class %s as the method is already implemented.", description.toString(), this.plasticClass.className));
        }
        this.plasticClass.introduceMethod(description, callback);
    }

    private void replaceFieldWriteAccess(String conduitFieldName) {
        String setAccessName = this.plasticClass.makeUnique(this.plasticClass.methodNames, "set_" + this.node.name);
        this.setAccess = new MethodNode(4112, setAccessName, "(" + this.node.desc + ")V", null, null);
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(this.setAccess);
        this.pushFieldConduitOntoStack(conduitFieldName, builder);
        builder.loadThis();
        this.plasticClass.pushInstanceContextFieldOntoStack(builder);
        builder.loadArgument(0);
        builder.boxPrimitive(this.typeName);
        builder.invoke(FieldConduit.class, Void.TYPE, "set", Object.class, InstanceContext.class, Object.class);
        if (this.isWriteBehindEnabled()) {
            builder.loadThis().loadArgument(0).putField(this.plasticClass.className, this.node.name, this.typeName);
        }
        builder.returnResult();
        this.plasticClass.addMethod(this.setAccess);
        this.plasticClass.fieldToWriteMethod.put(this.node.name, this.setAccess);
    }

    private void replaceFieldReadAccess(String conduitFieldName) {
        boolean writeBehindEnabled = this.isWriteBehindEnabled();
        String getAccessName = this.plasticClass.makeUnique(this.plasticClass.methodNames, "getfieldvalue_" + this.node.name);
        this.getAccess = new MethodNode(4112, getAccessName, "()" + this.node.desc, null, null);
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(this.getAccess);
        this.pushFieldConduitOntoStack(conduitFieldName, builder);
        builder.loadThis();
        this.plasticClass.pushInstanceContextFieldOntoStack(builder);
        builder.invoke(FieldConduit.class, Object.class, "get", Object.class, InstanceContext.class).castOrUnbox(this.typeName);
        if (writeBehindEnabled) {
            if (this.isWide()) {
                builder.dupeWide().loadThis().dupe(2).pop();
            } else {
                builder.dupe().loadThis().swap();
            }
            builder.putField(this.plasticClass.className, this.node.name, this.typeName);
        }
        builder.returnResult();
        this.plasticClass.addMethod(this.getAccess);
        this.plasticClass.fieldToReadMethod.put(this.node.name, this.getAccess);
    }

    private boolean isWriteBehindEnabled() {
        return this.plasticClass.pool.isEnabled(TransformationOption.FIELD_WRITEBEHIND);
    }

    private boolean isWide() {
        PrimitiveType pt = PrimitiveType.getByName(this.typeName);
        return pt != null && pt.isWide();
    }

    private void pushFieldConduitOntoStack(String conduitFileName, InstructionBuilder builder) {
        builder.loadThis();
        builder.getField(this.plasticClass.className, conduitFileName, FieldConduit.class);
    }

    private void makeReadOnly() {
        String setAccessName = this.plasticClass.makeUnique(this.plasticClass.methodNames, "setfieldvalue_" + this.node.name);
        this.setAccess = new MethodNode(4112, setAccessName, "(" + this.node.desc + ")V", null, null);
        String message = String.format("Field %s of class %s is read-only.", this.node.name, this.plasticClass.className);
        this.plasticClass.newBuilder(this.setAccess).throwException(IllegalStateException.class, message);
        this.plasticClass.addMethod(this.setAccess);
        this.plasticClass.fieldToWriteMethod.put(this.node.name, this.setAccess);
        this.node.access |= 0x10;
    }

    private MethodNode addShimSetAccessMethod() {
        String name = this.plasticClass.makeUnique(this.plasticClass.methodNames, "shimset_" + this.node.name);
        MethodNode mn = new MethodNode(4112, name, "(" + this.node.desc + ")V", null, null);
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(mn);
        builder.loadThis().loadArgument(0).putField(this.plasticClass.className, this.node.name, this.typeName);
        builder.returnResult();
        this.plasticClass.addMethod(mn);
        this.plasticClass.fieldTransformMethods.add(mn);
        return mn;
    }

    private MethodNode addShimGetAccessMethod() {
        String name = this.plasticClass.makeUnique(this.plasticClass.methodNames, "shimget_" + this.node.name);
        MethodNode mn = new MethodNode(4112, name, "()" + this.node.desc, null, null);
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(mn);
        builder.loadThis().getField(this.plasticClass.className, this.node.name, this.typeName).returnResult();
        this.plasticClass.addMethod(mn);
        this.plasticClass.fieldTransformMethods.add(mn);
        return mn;
    }

    void installShim(PlasticClassHandleShim shim) {
        if (this.handle != null) {
            this.handle.shim = shim;
        }
    }

    void extendShimGet(SwitchBlock switchBlock) {
        if (this.getAccess == null) {
            this.getAccess = this.addShimGetAccessMethod();
        }
        final String methodToInvoke = this.getAccess.name;
        this.plasticClass.shimInvokedMethods.add(this.getAccess);
        switchBlock.addCase(this.fieldIndex, false, new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.invokeVirtual(PlasticFieldImpl.this.plasticClass.className, PlasticFieldImpl.this.typeName, methodToInvoke, new String[0]).boxPrimitive(PlasticFieldImpl.this.typeName).returnResult();
            }
        });
    }

    void extendShimSet(SwitchBlock switchBlock) {
        if (this.setAccess == null) {
            this.setAccess = this.addShimSetAccessMethod();
        }
        this.plasticClass.shimInvokedMethods.add(this.setAccess);
        final String methodToInvoke = this.setAccess.name;
        switchBlock.addCase(this.fieldIndex, true, new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.castOrUnbox(PlasticFieldImpl.this.typeName);
                builder.invokeVirtual(PlasticFieldImpl.this.plasticClass.className, "void", methodToInvoke, PlasticFieldImpl.this.typeName);
            }
        });
    }
}

