/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.context.PortletActionContext;

public class PortletResult
extends StrutsResultSupport
implements PortletActionConstants {
    private static final long serialVersionUID = 434251393926178567L;
    private boolean useDispatcherServlet;
    private String dispatcherServletName = "Struts2PortletDispatcherServlet";
    private static final Logger LOG = LoggerFactory.getLogger(PortletResult.class);
    private String contentType = "text/html";
    private String title;
    protected PortletMode portletMode;

    public PortletResult() {
    }

    public PortletResult(String location) {
        super(location);
    }

    public void doExecute(String finalLocation, ActionInvocation actionInvocation) throws Exception {
        if (PortletActionContext.isRender()) {
            this.executeRenderResult(finalLocation);
        } else if (PortletActionContext.isEvent()) {
            this.executeActionResult(finalLocation, actionInvocation);
        } else {
            this.executeRegularServletResult(finalLocation, actionInvocation);
        }
    }

    private void executeRegularServletResult(String finalLocation, ActionInvocation actionInvocation) throws ServletException, IOException {
        ServletContext ctx = ServletActionContext.getServletContext();
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        try {
            ctx.getRequestDispatcher(finalLocation).include((ServletRequest)req, (ServletResponse)res);
        }
        catch (ServletException e) {
            LOG.error("ServletException including " + finalLocation, (Throwable)e, new String[0]);
            throw e;
        }
        catch (IOException e) {
            LOG.error("IOException while including result '" + finalLocation + "'", (Throwable)e, new String[0]);
            throw e;
        }
    }

    protected void executeActionResult(String finalLocation, ActionInvocation invocation) throws Exception {
        LOG.debug("Executing result in Event phase", new String[0]);
        ActionResponse res = PortletActionContext.getActionResponse();
        Map sessionMap = invocation.getInvocationContext().getSession();
        LOG.debug("Setting event render parameter: " + finalLocation, new String[0]);
        if (finalLocation.indexOf(63) != -1) {
            PortletResult.convertQueryParamsToRenderParams(res, finalLocation.substring(finalLocation.indexOf(63) + 1));
            finalLocation = finalLocation.substring(0, finalLocation.indexOf(63));
        }
        if (finalLocation.endsWith(".action")) {
            finalLocation = finalLocation.substring(0, finalLocation.lastIndexOf("."));
            res.setRenderParameter("struts.portlet.action", finalLocation);
        } else {
            String namespace = invocation.getProxy().getNamespace();
            if (namespace != null && namespace.length() > 0 && !namespace.endsWith("/")) {
                namespace = namespace + "/";
            }
            res.setRenderParameter("struts.portlet.action", namespace + "renderDirect");
            sessionMap.put("struts.portlet.renderDirectLocation", finalLocation);
        }
        if (this.portletMode != null) {
            res.setPortletMode(this.portletMode);
            res.setRenderParameter("struts.portlet.mode", this.portletMode.toString());
        } else {
            res.setRenderParameter("struts.portlet.mode", PortletActionContext.getRequest().getPortletMode().toString());
        }
    }

    protected static void convertQueryParamsToRenderParams(ActionResponse response, String queryParams) {
        StringTokenizer tok = new StringTokenizer(queryParams, "&");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            String key = token.substring(0, token.indexOf(61));
            String value = token.substring(token.indexOf(61) + 1);
            response.setRenderParameter(key, value);
        }
    }

    protected void executeRenderResult(String finalLocation) throws PortletException, IOException {
        LOG.debug("Executing result in Render phase", new String[0]);
        PortletContext ctx = PortletActionContext.getPortletContext();
        RenderRequest req = PortletActionContext.getRenderRequest();
        RenderResponse res = PortletActionContext.getRenderResponse();
        res.setContentType(this.contentType);
        if (TextUtils.stringSet((String)this.title)) {
            res.setTitle(this.title);
        }
        LOG.debug("Location: " + finalLocation, new String[0]);
        if (this.useDispatcherServlet) {
            req.setAttribute("struts.portlet.dispatchTo", (Object)finalLocation);
            PortletRequestDispatcher dispatcher = ctx.getNamedDispatcher(this.dispatcherServletName);
            if (dispatcher == null) {
                throw new PortletException("Could not locate dispatcher servlet \"" + this.dispatcherServletName + "\". Please configure it in your web.xml file");
            }
            dispatcher.include(req, res);
        } else {
            PortletRequestDispatcher dispatcher = ctx.getRequestDispatcher(finalLocation);
            if (dispatcher == null) {
                throw new PortletException("Could not locate dispatcher for '" + finalLocation + "'");
            }
            dispatcher.include(req, res);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPortletMode(String portletMode) {
        if (portletMode != null) {
            this.portletMode = new PortletMode(portletMode);
        }
    }

    @Inject(value="struts.portlet.useDispatcherServlet")
    public void setUseDispatcherServlet(String useDispatcherServlet) {
        this.useDispatcherServlet = "true".equalsIgnoreCase(useDispatcherServlet);
    }

    @Inject(value="struts.portlet.dispatcherServletName")
    public void setDispatcherServletName(String dispatcherServletName) {
        this.dispatcherServletName = dispatcherServletName;
    }
}

