/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.TimeSource;

public class DelegatingCloudManager
implements SolrCloudManager {
    protected final SolrCloudManager delegate;
    private ObjectCache objectCache = new ObjectCache();
    private TimeSource timeSource = TimeSource.NANO_TIME;

    public DelegatingCloudManager(SolrCloudManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.delegate.getClusterStateProvider();
    }

    @Override
    public NodeStateProvider getNodeStateProvider() {
        return this.delegate.getNodeStateProvider();
    }

    @Override
    public DistribStateManager getDistribStateManager() {
        return this.delegate.getDistribStateManager();
    }

    @Override
    public ObjectCache getObjectCache() {
        return this.delegate == null ? this.objectCache : this.delegate.getObjectCache();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public TimeSource getTimeSource() {
        return this.delegate == null ? this.timeSource : this.delegate.getTimeSource();
    }

    @Override
    public <T extends SolrResponse> T request(SolrRequest<T> req) throws IOException {
        return this.delegate.request(req);
    }

    @Override
    public byte[] httpRequest(String url, SolrRequest.METHOD method, Map<String, String> headers, String payload, int timeout, boolean followRedirects) throws IOException {
        return this.delegate.httpRequest(url, method, headers, payload, timeout, followRedirects);
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

