/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.dml.DeleteStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.dml.MergeStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementBinder;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;

public final class SQLBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String defaultDatabaseName;
    private final HintValueContext hintValueContext;

    public SQLStatementContext bind(SQLStatement sqlStatement, List<Object> params) {
        SQLStatement buoundedSQLStatement = this.bind(sqlStatement, this.metaData, this.defaultDatabaseName);
        return SQLStatementContextFactory.newInstance(this.metaData, params, buoundedSQLStatement, this.defaultDatabaseName);
    }

    private SQLStatement bind(SQLStatement statement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        if (this.hintValueContext.findHintDataSourceName().isPresent()) {
            return statement;
        }
        if (statement instanceof DMLStatement) {
            return SQLBindEngine.bindDMLStatement(statement, metaData, defaultDatabaseName);
        }
        if (statement instanceof DDLStatement) {
            return SQLBindEngine.bindDDLStatement(statement, metaData, defaultDatabaseName);
        }
        return statement;
    }

    private static SQLStatement bindDMLStatement(SQLStatement statement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        if (statement instanceof SelectStatement) {
            return new SelectStatementBinder().bind((SelectStatement)statement, metaData, defaultDatabaseName);
        }
        if (statement instanceof InsertStatement) {
            return new InsertStatementBinder().bind((InsertStatement)statement, metaData, defaultDatabaseName);
        }
        if (statement instanceof UpdateStatement) {
            return new UpdateStatementBinder().bind((UpdateStatement)statement, metaData, defaultDatabaseName);
        }
        if (statement instanceof DeleteStatement) {
            return new DeleteStatementBinder().bind((DeleteStatement)statement, metaData, defaultDatabaseName);
        }
        if (statement instanceof MergeStatement) {
            return new MergeStatementBinder().bind((MergeStatement)statement, metaData, defaultDatabaseName);
        }
        return statement;
    }

    private static SQLStatement bindDDLStatement(SQLStatement statement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        if (statement instanceof OpenGaussCursorStatement) {
            return new CursorStatementBinder().bind((OpenGaussCursorStatement)statement, metaData, defaultDatabaseName);
        }
        return statement;
    }

    @Generated
    public SQLBindEngine(ShardingSphereMetaData metaData, String defaultDatabaseName, HintValueContext hintValueContext) {
        this.metaData = metaData;
        this.defaultDatabaseName = defaultDatabaseName;
        this.hintValueContext = hintValueContext;
    }
}

