/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ValidateConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable,
ConstraintAvailable {
    private final TablesContext tablesContext;

    public AlterTableStatementContext(AlterTableStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable(), this.getDatabaseType());
    }

    public AlterTableStatement getSqlStatement() {
        return (AlterTableStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(this.getSqlStatement().getTable());
        if (this.getSqlStatement().getRenameTable().isPresent()) {
            result.add((SimpleTableSegment)this.getSqlStatement().getRenameTable().get());
        }
        for (AddColumnDefinitionSegment each : this.getSqlStatement().getAddColumnDefinitions()) {
            for (ColumnDefinitionSegment columnDefinition : each.getColumnDefinitions()) {
                result.addAll(columnDefinition.getReferencedTables());
            }
        }
        for (AddColumnDefinitionSegment each : this.getSqlStatement().getModifyColumnDefinitions()) {
            result.addAll(each.getColumnDefinition().getReferencedTables());
        }
        for (AddColumnDefinitionSegment each : this.getSqlStatement().getAddConstraintDefinitions()) {
            each.getConstraintDefinition().getReferencedTable().ifPresent(result::add);
        }
        return result;
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (AddConstraintDefinitionSegment each : this.getSqlStatement().getAddConstraintDefinitions()) {
            each.getConstraintDefinition().getIndexName().ifPresent(result::add);
        }
        this.getSqlStatement().getDropIndexDefinitions().stream().map(DropIndexDefinitionSegment::getIndexSegment).forEach(result::add);
        for (AddConstraintDefinitionSegment each : this.getSqlStatement().getRenameIndexDefinitions()) {
            result.add(each.getIndexSegment());
            result.add(each.getRenameIndexSegment());
        }
        return result;
    }

    @Override
    public Collection<ConstraintSegment> getConstraints() {
        LinkedList<ConstraintSegment> result = new LinkedList<ConstraintSegment>();
        for (AddConstraintDefinitionSegment each : this.getSqlStatement().getAddConstraintDefinitions()) {
            each.getConstraintDefinition().getConstraintName().ifPresent(result::add);
        }
        this.getSqlStatement().getValidateConstraintDefinitions().stream().map(ValidateConstraintDefinitionSegment::getConstraintName).forEach(result::add);
        this.getSqlStatement().getDropConstraintDefinitions().stream().map(DropConstraintDefinitionSegment::getConstraintName).forEach(result::add);
        return result;
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (AddConstraintDefinitionSegment each : this.getSqlStatement().getAddConstraintDefinitions()) {
            result.addAll(each.getConstraintDefinition().getIndexColumns());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

