/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.core.ApplicationIdResolver;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.internal.Configuration;
import org.apache.pluto.internal.InternalPortletConfig;
import org.apache.pluto.internal.InternalPortletContext;
import org.apache.pluto.internal.PortletDescriptorRegistry;
import org.apache.pluto.internal.impl.PortletConfigImpl;
import org.apache.pluto.internal.impl.PortletContextImpl;
import org.apache.pluto.spi.optional.PortletRegistryEvent;
import org.apache.pluto.spi.optional.PortletRegistryListener;
import org.apache.pluto.spi.optional.PortletRegistryService;
import org.apache.pluto.util.ClasspathScanner;

public class PortletContextManager
implements PortletRegistryService {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$core$PortletContextManager == null ? (class$org$apache$pluto$core$PortletContextManager = PortletContextManager.class$("org.apache.pluto.core.PortletContextManager")) : class$org$apache$pluto$core$PortletContextManager));
    private static final PortletContextManager MANAGER = new PortletContextManager();
    private static final List APP_ID_RESOLVERS = new ArrayList();
    private final Map portletContexts = new HashMap();
    private final Map portletConfigs = new HashMap();
    private final List registryListeners = new ArrayList();
    private static Method contextPathGetter;
    static /* synthetic */ Class class$org$apache$pluto$core$PortletContextManager;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$org$apache$pluto$core$ApplicationIdResolver;

    private PortletContextManager() {
    }

    public static PortletContextManager getManager() {
        return MANAGER;
    }

    public String register(ServletConfig config) throws PortletContainerException {
        InternalPortletContext portletContext = this.register(config.getServletContext());
        PortletAppDD portletAppDD = portletContext.getPortletApplicationDefinition();
        PortletDD portletDD = null;
        LOG.info((Object)("Registering " + portletAppDD.getPortlets().size() + " portlets for context " + portletContext.getApplicationId()));
        Iterator it = portletAppDD.getPortlets().iterator();
        while (it.hasNext()) {
            portletDD = (PortletDD)it.next();
            this.portletConfigs.put(portletContext.getApplicationId() + "/" + portletDD.getPortletName(), new PortletConfigImpl(config, portletContext, portletDD));
        }
        return portletContext.getApplicationId();
    }

    public InternalPortletContext register(ServletContext servletContext) throws PortletContainerException {
        String applicationId = PortletContextManager.getContextPath(servletContext);
        if (!this.portletContexts.containsKey(applicationId)) {
            PortletAppDD portletAppDD = PortletDescriptorRegistry.getRegistry().getPortletAppDD(servletContext);
            PortletContextImpl portletContext = new PortletContextImpl(applicationId, servletContext, portletAppDD);
            if (portletContext.getApplicationId() == null) {
                throw new IllegalStateException("Unable to resolve unique identifier for portletContext.");
            }
            this.portletContexts.put(applicationId, portletContext);
            this.fireRegistered(portletContext);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Registered portlet application with application id '" + applicationId + "'"));
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Portlet application with application id '" + applicationId + "' already registered."));
        }
        return (InternalPortletContext)this.portletContexts.get(applicationId);
    }

    public void remove(InternalPortletContext context) {
        this.portletContexts.remove(context.getApplicationId());
        Iterator configs = this.portletConfigs.keySet().iterator();
        while (configs.hasNext()) {
            String key = (String)configs.next();
            if (!key.startsWith(context.getApplicationId() + "/")) continue;
            configs.remove();
        }
        this.fireRemoved(context);
    }

    public Iterator getRegisteredPortletApplicationIds() {
        return new HashSet(this.portletContexts.keySet()).iterator();
    }

    public Iterator getRegisteredPortletApplications() {
        return new HashSet(this.portletContexts.values()).iterator();
    }

    public PortletContext getPortletContext(String applicationId) throws PortletContainerException {
        return (InternalPortletContext)this.portletContexts.get(applicationId);
    }

    public PortletConfig getPortletConfig(String applicationId, String portletName) {
        String lookup = applicationId + "/" + portletName;
        if (!this.portletConfigs.containsKey(lookup)) {
            LOG.info((Object)("Unable to locate portlet config [applicationId=" + applicationId + "]/[" + portletName + "]."));
        }
        return (InternalPortletConfig)this.portletConfigs.get(lookup);
    }

    public PortletDD getPortletDescriptor(String applicationId, String portletName) {
        InternalPortletConfig ipc = (InternalPortletConfig)this.portletConfigs.get(applicationId + "/" + portletName);
        if (ipc != null) {
            return ipc.getPortletDefinition();
        }
        LOG.warn((Object)("Unable to retrieve portlet descriptor: '" + applicationId + "/" + portletName + "'"));
        return null;
    }

    public PortletAppDD getPortletApplicationDescriptor(String applicationId) throws PortletContainerException {
        InternalPortletContext ipc = (InternalPortletContext)this.portletContexts.get(applicationId);
        if (ipc != null) {
            return ipc.getPortletApplicationDefinition();
        }
        String msg = "Unable to retrieve portlet application descriptor: '" + applicationId + "'";
        LOG.warn((Object)msg);
        throw new PortletContainerException(msg);
    }

    public void addPortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.add(listener);
    }

    public void removePortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    private void fireRegistered(InternalPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setApplicationId(context.getApplicationId());
        event.setPortletApplicationDescriptor(context.getPortletApplicationDefinition());
        Iterator i = this.registryListeners.iterator();
        while (i.hasNext()) {
            ((PortletRegistryListener)i.next()).portletApplicationRegistered(event);
        }
        LOG.info((Object)("Portlet Context '" + context.getApplicationId() + "' registered."));
    }

    private void fireRemoved(InternalPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setApplicationId(context.getApplicationId());
        event.setPortletApplicationDescriptor(context.getPortletApplicationDefinition());
        Iterator i = this.registryListeners.iterator();
        while (i.hasNext()) {
            ((PortletRegistryListener)i.next()).portletApplicationRemoved(event);
        }
        LOG.info((Object)("Portlet Context '" + context.getApplicationId() + "' removed."));
    }

    public static ServletContext getPortletContext(ServletContext portalContext, String portletContextPath) {
        String portalPath;
        if (Configuration.preventUnecessaryCrossContext() && (portalPath = PortletContextManager.getContextPath(portalContext)).equals(portletContextPath)) {
            return portalContext;
        }
        return portalContext.getContext(portletContextPath);
    }

    protected static String getContextPath(ServletContext context) {
        String contextPath = null;
        if (contextPathGetter != null) {
            try {
                contextPath = (String)contextPathGetter.invoke((Object)context, (Object[])new Class[0]);
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to directly retrieve context path from ServletContext. Computing. . . ");
            }
        }
        if (contextPath == null) {
            contextPath = PortletContextManager.computeContextPath(context);
        }
        return contextPath;
    }

    protected static String computeContextPath(ServletContext context) {
        if (APP_ID_RESOLVERS.size() < 1) {
            List classes = null;
            try {
                classes = ClasspathScanner.findConfiguredImplementations(class$org$apache$pluto$core$ApplicationIdResolver == null ? (class$org$apache$pluto$core$ApplicationIdResolver = PortletContextManager.class$("org.apache.pluto.core.ApplicationIdResolver")) : class$org$apache$pluto$core$ApplicationIdResolver);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find any ApplicationIdResolvers");
            }
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                Class c = (Class)i.next();
                try {
                    APP_ID_RESOLVERS.add(c.newInstance());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unable to instantiate ApplicationIdResolver for class " + c.getName()));
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Found " + APP_ID_RESOLVERS.size() + " application id resolvers."));
            }
        }
        String path = null;
        int authority = Integer.MAX_VALUE;
        Iterator i = APP_ID_RESOLVERS.iterator();
        while (i.hasNext()) {
            ApplicationIdResolver resolver = (ApplicationIdResolver)i.next();
            if (resolver.getAuthority() >= authority && path != null) continue;
            authority = resolver.getAuthority();
            String temp = resolver.resolveApplicationId(context);
            if (temp == null) continue;
            path = temp;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved application id '" + path + "' with authority " + authority));
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            contextPathGetter = (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = PortletContextManager.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getMethod("getContextPath", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)"Servlet 2.4 or below detected.  Unable to find getContextPath on ServletContext.");
        }
    }
}

