/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.InjectableMethod;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.Asserts;

public class ProducerMethodProducer<T, P>
extends AbstractProducer<T> {
    private Bean<P> owner;
    private WebBeansContext webBeansContext;
    private Method producerMethod;
    private Method disposalMethod;
    private Set<InjectionPoint> disposalIPs;

    public ProducerMethodProducer(Bean<P> owner, AnnotatedMethod<? super P> producerMethod, AnnotatedMethod<? super P> disposerMethod, Set<InjectionPoint> points, Set<InjectionPoint> disposalIPs, WebBeansContext webBeansContext) {
        super(points);
        Asserts.assertNotNull(owner, "owner may not be null");
        Asserts.assertNotNull(producerMethod, "method may not be null");
        Asserts.assertNotNull(webBeansContext, "WebBeansContext may not be null");
        if (!producerMethod.isStatic()) {
            Asserts.assertNotNull(owner, "owner may not be null for non-static producer method");
        }
        this.owner = owner;
        this.webBeansContext = webBeansContext;
        this.disposalIPs = disposalIPs;
        OpenWebBeansEjbPlugin ejbPlugin = webBeansContext.getPluginLoader().getEjbPlugin();
        if (ejbPlugin != null) {
            this.producerMethod = ejbPlugin.resolveViewMethod(owner, producerMethod.getJavaMember());
            if (disposerMethod != null) {
                this.disposalMethod = ejbPlugin.resolveViewMethod(owner, disposerMethod.getJavaMember());
            }
        } else {
            this.producerMethod = producerMethod.getJavaMember();
            if (disposerMethod != null) {
                this.disposalMethod = disposerMethod.getJavaMember();
            }
        }
    }

    public void specializeBy(Bean<P> bean) {
        this.owner = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T produce(CreationalContext<T> creationalContext) {
        Object parentInstance = null;
        CreationalContext parentCreationalContext = null;
        try {
            parentCreationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.owner);
            if (!Modifier.isStatic(this.producerMethod.getModifiers())) {
                parentInstance = this.webBeansContext.getBeanManagerImpl().getReference(this.owner, this.owner.getBeanClass(), parentCreationalContext);
            }
            InjectableMethod m = new InjectableMethod(this.producerMethod, parentInstance, this, (CreationalContextImpl)creationalContext);
            Object t = m.doInjection();
            return t;
        }
        finally {
            if (parentCreationalContext != null) {
                parentCreationalContext.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T instance) {
        if (this.disposalMethod != null) {
            Object parentInstance = null;
            CreationalContext parentCreationalContext = null;
            try {
                parentCreationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.owner);
                if (!Modifier.isStatic(this.disposalMethod.getModifiers())) {
                    parentInstance = this.webBeansContext.getBeanManagerImpl().getReference(this.owner, this.owner.getBeanClass(), parentCreationalContext);
                }
                InjectableMethod m = new InjectableMethod(this.disposalMethod, parentInstance, this, (CreationalContextImpl)parentCreationalContext, this.disposalIPs);
                m.setDisposable(true);
                m.setProducerMethodInstance(instance);
                m.doInjection();
            }
            finally {
                parentCreationalContext.release();
            }
        }
    }
}

