/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.annotation.Annotation;
import java.util.Stack;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointBean
extends AbstractOwbBean<InjectionPoint> {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(InjectionPointBean.class);
    private static ThreadLocal<Stack<InjectionPoint>> localThreadlocalStack = new ThreadLocal();

    private static Stack<InjectionPoint> getStackOfInjectionPoints() {
        Stack<Object> stackIP = localThreadlocalStack.get();
        if (null == stackIP) {
            stackIP = new Stack();
        }
        return stackIP;
    }

    public static boolean setThreadLocal(InjectionPoint ip) {
        Stack<InjectionPoint> stackIP = InjectionPointBean.getStackOfInjectionPoints();
        stackIP.push(ip);
        localThreadlocalStack.set(stackIP);
        logger.debug("PUSHED IP on stack {0}", stackIP);
        return true;
    }

    public static void unsetThreadLocal() {
        Stack<InjectionPoint> stackIP = InjectionPointBean.getStackOfInjectionPoints();
        InjectionPoint ip = stackIP.pop();
        logger.debug("POPPED IP on stack {0}", ip);
    }

    public static void removeThreadLocal() {
        logger.debug(" local.remove() ");
        InjectionPointBean.getStackOfInjectionPoints().clear();
        localThreadlocalStack.remove();
    }

    public InjectionPointBean(WebBeansContext webBeansContext) {
        super(WebBeansType.INJECTIONPOINT, InjectionPoint.class, webBeansContext);
        this.addQualifier((Annotation)((Object)new DefaultLiteral()));
        this.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        this.addApiType(InjectionPoint.class);
        this.addApiType(Object.class);
    }

    public static boolean isStackEmpty() {
        return InjectionPointBean.getStackOfInjectionPoints().isEmpty();
    }

    @Override
    protected InjectionPoint createInstance(CreationalContext<InjectionPoint> creationalContext) {
        logger.debug("ENTRY createInstance {0}", creationalContext);
        InjectionPoint ip = InjectionPointBean.getStackOfInjectionPoints().peek();
        logger.debug("RETURN {0}", ip);
        return ip;
    }

    @Override
    protected void destroyInstance(InjectionPoint instance, CreationalContext<InjectionPoint> creationalContext) {
        InjectionPointBean.removeThreadLocal();
    }

    @Override
    public boolean isPassivationCapable() {
        return true;
    }
}

