/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.openjpa.lib.util.Localizer;

public class SourceCode {
    private static Localizer _loc = Localizer.forPackage(SourceCode.class);
    private static final ArrayList<String> reserved = new ArrayList();
    private static final ArrayList<String> knownTypes = new ArrayList();
    private static int TABSIZE = 4;
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String SEMICOLON = ";";
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String EQUAL = "=";
    public static final String QUOTE = "\"";
    private static final Delimiter BLOCK_DELIMITER = new Delimiter("{}");
    private static final Delimiter ARGS_DELIMITER = new Delimiter("()");
    private static final Delimiter PARAMS_DELIMITER = new Delimiter("<>");
    private List<Comment> comments;
    private final Package pkg;
    private final Class cls;
    private final Set<Import> imports = new TreeSet<Import>();

    public SourceCode(String c) {
        ClassName name = this.getOrCreateImport(c);
        this.cls = new Class(c);
        this.pkg = new Package(name.getPackageName());
    }

    public Class getTopLevelClass() {
        return this.cls;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public SourceCode setTabSize(int t) {
        if (t > 0) {
            TABSIZE = Math.max(t, 8);
        }
        return this;
    }

    private boolean addImport(ClassName name) {
        String pkgName = name.getPackageName();
        for (Import i : this.imports) {
            if (!i.getClassName().hides(name)) continue;
            i.getClassName().useFullName();
            name.useFullName();
        }
        return this.imports.add(new Import(name));
    }

    public ClassName getOrCreateImport(String name) {
        for (Import i : this.imports) {
            if (!i.name.getFullName().equals(name)) continue;
            return i.name;
        }
        ClassName imp = new ClassName(name);
        this.addImport(imp);
        return imp;
    }

    public SourceCode addComment(boolean inline, String ... lines) {
        if (lines == null) {
            return this;
        }
        if (this.comments == null) {
            this.comments = new ArrayList<Comment>();
        }
        Comment comment = new Comment();
        this.comments.add(comment);
        comment.makeInline(inline);
        for (String line : lines) {
            if (line.length() > 116) {
                String[] wrappedLines;
                for (String w : wrappedLines = SourceCode.wrap(line, 116)) {
                    comment.append(w);
                }
                continue;
            }
            comment.append(line);
        }
        return this;
    }

    public void write(PrintWriter out) {
        if (this.comments != null) {
            for (Comment comment : this.comments) {
                comment.write(out, 0);
                out.println();
            }
        }
        if (this.pkg != null) {
            this.pkg.write(out, 0);
            out.println();
        }
        for (Import imp : this.imports) {
            imp.write(out, 0);
        }
        out.println();
        this.cls.write(out, 0);
        out.flush();
    }

    static void tab(PrintWriter out, int tab) {
        for (int i = 0; i < tab * TABSIZE; ++i) {
            out.print(SPACE);
        }
    }

    public static String[] wrap(String longLine, int width) {
        String[] words = longLine.split("\\ ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            if (line.length() + w.length() < width) {
                if (line.length() > 0) {
                    line.append(SPACE);
                }
                line.append(w);
                continue;
            }
            lines.add(line.toString());
            line.setLength(0);
            line.append(w);
        }
        lines.add(line.toString());
        return lines.toArray(new String[lines.size()]);
    }

    static void writeList(PrintWriter out, String header, List<?> list) {
        SourceCode.writeList(out, header, list, new Delimiter(), false);
    }

    static void writeList(PrintWriter out, String header, List<?> list, Delimiter bracket, boolean writeEmpty) {
        if (list == null || list.isEmpty()) {
            if (writeEmpty) {
                out.append(bracket.start).append(bracket.end);
            }
            return;
        }
        out.append(header);
        out.append(bracket.start);
        for (int i = 0; i < list.size(); ++i) {
            out.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            out.append(COMMA);
        }
        out.append(bracket.end);
    }

    static String capitalize(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    static boolean isValidToken(String s) {
        return s != null && s.length() > 0 && !reserved.contains(s) && SourceCode.isJavaIdentifier(s);
    }

    public static boolean isKnownType(String s) {
        return knownTypes.contains(s);
    }

    static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    static LinkedList<String> tokenize(String s, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(s, delim, false);
        LinkedList<String> tokens = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        reserved.add("abstract");
        reserved.add("continue");
        reserved.add("for");
        reserved.add("new");
        reserved.add("switch");
        reserved.add("assert");
        reserved.add("default");
        reserved.add("goto");
        reserved.add("package");
        reserved.add("synchronized");
        reserved.add("boolean");
        reserved.add("do");
        reserved.add("if");
        reserved.add("private");
        reserved.add("this");
        reserved.add("break");
        reserved.add("double");
        reserved.add("implements");
        reserved.add("protected");
        reserved.add("throw");
        reserved.add("byte");
        reserved.add("else");
        reserved.add("import");
        reserved.add("public");
        reserved.add("throws");
        reserved.add("case");
        reserved.add("enum");
        reserved.add("instanceof");
        reserved.add("return");
        reserved.add("transient");
        reserved.add("catch");
        reserved.add("extends");
        reserved.add("int");
        reserved.add("short");
        reserved.add("try");
        reserved.add("char");
        reserved.add("final");
        reserved.add("interface");
        reserved.add("static");
        reserved.add("void");
        reserved.add("class");
        reserved.add("finally");
        reserved.add("long");
        reserved.add("strictfp");
        reserved.add("volatile");
        reserved.add("const");
        reserved.add("float");
        reserved.add("native");
        reserved.add("super");
        reserved.add("while");
        knownTypes.add("boolean");
        knownTypes.add("byte");
        knownTypes.add("char");
        knownTypes.add("double");
        knownTypes.add("float");
        knownTypes.add("int");
        knownTypes.add("long");
        knownTypes.add("short");
        knownTypes.add("void");
        knownTypes.add("String");
    }

    static class Delimiter {
        final char start;
        final char end;

        public Delimiter() {
            this(' ', ' ');
        }

        public Delimiter(String pair) {
            this(pair.charAt(0), pair.charAt(1));
        }

        public Delimiter(char start, char end) {
            this.start = start;
            this.end = end;
        }
    }

    private class ClassName
    implements Comparable<ClassName> {
        public final String fullName;
        public final String simpleName;
        public final String pkgName;
        private String arrayMarker = "";
        private boolean useFullName = false;

        ClassName(String name) {
            while (this.isArray(name)) {
                this.arrayMarker = this.arrayMarker + "[]";
                name = this.getComponentName(name);
            }
            int start = name.indexOf("<");
            int stop = name.lastIndexOf(">");
            if (start != -1 && stop != -1) {
                name = name.substring(0, start) + name.substring(stop + 1);
            }
            this.fullName = name;
            int dot = this.fullName.lastIndexOf(SourceCode.DOT);
            this.simpleName = dot == -1 ? this.fullName : this.fullName.substring(dot + 1);
            String string = this.pkgName = dot == -1 ? SourceCode.BLANK : this.fullName.substring(0, dot);
            if (!this.isValidTypeName(name)) {
                throw new IllegalArgumentException(_loc.get("src-invalid-type", name).toString());
            }
        }

        public String getFullName() {
            return this.fullName + this.arrayMarker;
        }

        public String getSimpleName() {
            return this.simpleName + this.arrayMarker;
        }

        public String getPackageName() {
            return this.pkgName;
        }

        public String toString() {
            return (this.useFullName ? this.fullName : this.simpleName) + this.arrayMarker;
        }

        @Override
        public int compareTo(ClassName other) {
            return this.getFullName().compareTo(other.getFullName());
        }

        public boolean isValidTypeName(String s) {
            return this.isValidPackageName(this.pkgName) && (SourceCode.isKnownType(s) || SourceCode.isValidToken(this.simpleName));
        }

        boolean isValidPackageName(String s) {
            if (SourceCode.isEmpty(s)) {
                return true;
            }
            LinkedList<String> tokens = SourceCode.tokenize(s, SourceCode.DOT);
            for (String token : tokens) {
                if (SourceCode.isValidToken(token)) continue;
                return false;
            }
            return !s.endsWith(SourceCode.DOT);
        }

        boolean isArray(String name) {
            return name.endsWith("[]");
        }

        String getComponentName(String name) {
            return !this.isArray(name) ? name : name.substring(0, name.length() - "[]".length());
        }

        boolean hides(ClassName other) {
            return this.getSimpleName().equals(other.getSimpleName()) && !this.fullName.equals(other.fullName);
        }

        void useFullName() {
            this.useFullName = true;
        }

        boolean usingFullName() {
            return this.useFullName;
        }
    }

    class Comment {
        List<String> lines = new ArrayList<String>();
        private boolean inline = false;

        Comment() {
        }

        public void append(String line) {
            this.lines.add(line);
        }

        boolean isEmpty() {
            return this.lines.isEmpty();
        }

        void makeInline(boolean flag) {
            this.inline = flag;
        }

        public void write(PrintWriter out, int tab) {
            if (this.inline) {
                for (String l : this.lines) {
                    SourceCode.tab(out, tab);
                    out.println("// " + l);
                }
            } else {
                int i = 0;
                for (String l : this.lines) {
                    SourceCode.tab(out, tab);
                    if (i == 0) {
                        out.println("/** ");
                        SourceCode.tab(out, tab);
                    }
                    out.println(" *  " + l);
                    ++i;
                }
                SourceCode.tab(out, tab);
                out.println("**/");
            }
        }
    }

    static class Package {
        private String name;

        Package(String p) {
            this.name = p;
        }

        public void write(PrintWriter out, int tab) {
            if (this.name != null && !this.name.isEmpty()) {
                out.println("package " + this.name + SourceCode.SEMICOLON);
            }
        }
    }

    public class Annotation {
        private String name;
        private List<Argument<?, ?>> args = new ArrayList();

        Annotation(String n) {
            this.name = n;
        }

        public Annotation addArgument(String key, String v, boolean quote) {
            return this.addArgument(new Argument<String, String>(key, quote ? this.quote(v) : v, SourceCode.EQUAL));
        }

        public Annotation addArgument(String key, String v) {
            return this.addArgument(key, v, true);
        }

        public Annotation addArgument(String key, String[] vs) {
            StringBuilder tmp = new StringBuilder(BLOCK_DELIMITER.start);
            for (int i = 0; i < vs.length; ++i) {
                tmp.append(this.quote(vs[i]));
                tmp.append(i != vs.length - 1 ? SourceCode.COMMA : SourceCode.BLANK);
            }
            tmp.append(BLOCK_DELIMITER.end);
            return this.addArgument(key, tmp.toString(), false);
        }

        public <K, V> Annotation addArgument(Argument<K, V> arg) {
            this.args.add(arg);
            return this;
        }

        public void write(PrintWriter out, int tab) {
            SourceCode.tab(out, tab);
            out.println("@" + this.name);
            SourceCode.writeList(out, SourceCode.BLANK, this.args, ARGS_DELIMITER, false);
            out.println();
        }

        String quote(String s) {
            return SourceCode.QUOTE + s + SourceCode.QUOTE;
        }
    }

    public class Argument<K, V> {
        private final K key;
        private final V value;
        private final String connector;

        Argument(K key, V value, String connector) {
            this.key = key;
            this.value = value;
            this.connector = connector;
        }

        public String toString() {
            return this.key + this.connector + this.value;
        }
    }

    class Import
    implements Comparable<Import> {
        private final ClassName name;

        public Import(ClassName name) {
            this.name = name;
        }

        @Override
        public int compareTo(Import other) {
            return this.name.compareTo(other.name);
        }

        public void write(PrintWriter out, int tab) {
            if (this.name.usingFullName()) {
                return;
            }
            String pkg = this.name.getPackageName();
            if (pkg.length() == 0 || pkg.equals(SourceCode.this.getPackage().name)) {
                return;
            }
            out.println("import " + this.name.fullName + SourceCode.SEMICOLON);
        }

        public boolean equals(Object other) {
            if (other instanceof Import) {
                Import that = (Import)other;
                return this.name.equals(that.name);
            }
            return false;
        }

        ClassName getClassName() {
            return this.name;
        }
    }

    public class Constructor
    extends Element<Constructor> {
        private List<Argument<ClassName, String>> args;
        private List<String> codeLines;
        int tabCount;
        String tab;

        public Constructor(String name) {
            super(name, null);
            this.args = new ArrayList<Argument<ClassName, String>>();
            this.codeLines = new ArrayList<String>();
            this.tabCount = 0;
            this.tab = SourceCode.BLANK;
            this.makePublic();
        }

        public Constructor addArgument(Argument<ClassName, String> arg) {
            this.args.add(arg);
            return this;
        }

        public Constructor addArgument(String className, String argName) {
            ClassName cn = SourceCode.this.getOrCreateImport(className);
            this.args.add(new Argument<ClassName, String>(cn, argName, SourceCode.SPACE));
            return this;
        }

        public Constructor addCodeLine(String line) {
            if (line.endsWith("{") || line.endsWith("}")) {
                // empty if block
            }
            if (!(line.endsWith(SourceCode.SEMICOLON) || line.isEmpty() || line.endsWith("{") || line.endsWith("}") || line.startsWith("if"))) {
                line = line + SourceCode.SEMICOLON;
            }
            this.codeLines.add(this.tab + line);
            return this;
        }

        public Constructor addCodeLine(String line, boolean tabInc) {
            this.setTab(tabInc);
            return this.addCodeLine(line);
        }

        public void setTab(boolean inc) {
            this.tabCount = inc ? ++this.tabCount : --this.tabCount;
            this.tab = SourceCode.BLANK;
            for (int i = 0; i < this.tabCount * TABSIZE; ++i) {
                this.tab = this.tab + SourceCode.SPACE;
            }
        }

        @Override
        public void write(PrintWriter out, int tab) {
            out.println(SourceCode.BLANK);
            super.write(out, tab);
            out.print(this.name);
            SourceCode.writeList(out, SourceCode.BLANK, this.args, ARGS_DELIMITER, true);
            out.println(SourceCode.SPACE + BLOCK_DELIMITER.start);
            for (String line : this.codeLines) {
                SourceCode.tab(out, tab + 1);
                out.println(line);
            }
            SourceCode.tab(out, tab);
            out.println(BLOCK_DELIMITER.end);
        }
    }

    public class Method
    extends Element<Method> {
        private boolean isAbstract;
        private List<Argument<ClassName, String>> args;
        private List<String> codeLines;
        int tabCount;
        String tab;

        Method(String n, String t) {
            this(n, sourceCode.getOrCreateImport(t));
        }

        public Method(String name, ClassName returnType) {
            super(name, returnType);
            this.args = new ArrayList<Argument<ClassName, String>>();
            this.codeLines = new ArrayList<String>();
            this.tabCount = 0;
            this.tab = SourceCode.BLANK;
            this.makePublic();
        }

        public Method addArgument(Argument<ClassName, String> arg) {
            this.args.add(arg);
            return this;
        }

        public Method addArgument(String className, String argName) {
            ClassName cn = SourceCode.this.getOrCreateImport(className);
            this.args.add(new Argument<ClassName, String>(cn, argName, SourceCode.SPACE));
            return this;
        }

        public void setTab(boolean inc) {
            this.tabCount = inc ? ++this.tabCount : --this.tabCount;
            this.tab = SourceCode.BLANK;
            for (int i = 0; i < this.tabCount * TABSIZE; ++i) {
                this.tab = this.tab + SourceCode.SPACE;
            }
        }

        public Method addCodeLine(String line) {
            if (this.isAbstract) {
                throw new IllegalStateException("abstract method " + this.name + " can not have body");
            }
            if (line.endsWith("{") || line.endsWith("}")) {
                // empty if block
            }
            if (!(line.endsWith(SourceCode.SEMICOLON) || line.isEmpty() || line.endsWith("{") || line.endsWith("}") || line.startsWith("if"))) {
                line = line + SourceCode.SEMICOLON;
            }
            this.codeLines.add(this.tab + line);
            return this;
        }

        public Method addCodeLine(String line, boolean tabInc) {
            this.setTab(tabInc);
            return this.addCodeLine(line);
        }

        public Method makeAbstract() {
            if (!this.codeLines.isEmpty()) {
                throw new IllegalStateException("method " + this.name + " can not be abstract. It has a body");
            }
            this.isAbstract = true;
            return this;
        }

        public String toString() {
            return this.type + SourceCode.SPACE + this.name;
        }

        @Override
        public void write(PrintWriter out, int tab) {
            out.println(SourceCode.BLANK);
            super.write(out, tab);
            if (this.isAbstract) {
                out.append("abstract ");
            }
            out.print(this.type + SourceCode.SPACE + this.name);
            SourceCode.writeList(out, SourceCode.BLANK, this.args, ARGS_DELIMITER, true);
            if (this.isAbstract) {
                out.println(SourceCode.SEMICOLON);
                return;
            }
            out.println(SourceCode.SPACE + BLOCK_DELIMITER.start);
            for (String line : this.codeLines) {
                SourceCode.tab(out, tab + 1);
                out.println(line);
            }
            SourceCode.tab(out, tab);
            out.println(BLOCK_DELIMITER.end);
        }

        public boolean equals(Object other) {
            if (other instanceof Method) {
                Method that = (Method)other;
                return this.name.equals(that.name) && ((Object)this.args).equals(that.args);
            }
            return false;
        }
    }

    public class Field
    extends Element<Field> {
        private final Class owner;
        protected boolean isTransient;
        protected boolean isVolatile;

        Field(Class owner, String name, ClassName type) {
            super(name, type);
            this.owner = owner;
            this.makePrivate();
        }

        public Field markAsBean() {
            this.addGetter();
            this.addSetter();
            return this;
        }

        public Field addGetter() {
            ((Method)this.owner.addMethod("get" + SourceCode.capitalize(this.name), this.type).makePublic()).addCodeLine("return " + this.name);
            return this;
        }

        public Field addSetter() {
            ((Method)this.owner.addMethod("set" + SourceCode.capitalize(this.name), "void").makePublic()).addArgument(new Argument<ClassName, String>(this.type, this.name, SourceCode.SPACE)).addCodeLine("this." + this.name + " = " + this.name);
            return this;
        }

        public void makeVolatile() {
            this.isVolatile = true;
        }

        public void makeTransient() {
            this.isTransient = true;
        }

        public String toString() {
            return this.type + SourceCode.SPACE + this.name;
        }

        @Override
        public void write(PrintWriter out, int tab) {
            super.write(out, tab);
            if (this.isVolatile) {
                out.print("volatile ");
            }
            if (this.isTransient) {
                out.print("transient ");
            }
            out.print(this.type);
            SourceCode.writeList(out, SourceCode.BLANK, this.params, PARAMS_DELIMITER, false);
            out.println(SourceCode.SPACE + this.name + SourceCode.SEMICOLON);
        }

        public boolean equals(Object other) {
            if (other instanceof Field) {
                Field that = (Field)other;
                return this.name.equals(that.name);
            }
            return false;
        }
    }

    public class Class
    extends Element<Class> {
        private boolean isAbstract;
        private boolean isFinal;
        private ClassName superCls;
        private List<ClassName> interfaces;
        private Set<Field> fields;
        private Set<Method> methods;
        private Set<Constructor> constructors;

        public Class(String name) {
            super(name, SourceCode.this.getOrCreateImport(name));
            this.interfaces = new ArrayList<ClassName>();
            this.fields = new TreeSet<Field>();
            this.methods = new TreeSet<Method>();
            this.constructors = new TreeSet<Constructor>();
            this.makePublic();
        }

        public Class setSuper(String s) {
            this.superCls = SourceCode.this.getOrCreateImport(s);
            return this;
        }

        public Class addInterface(String s) {
            this.interfaces.add(SourceCode.this.getOrCreateImport(s));
            return this;
        }

        public Class makeAbstract() {
            if (this.isFinal) {
                throw new IllegalArgumentException(_loc.get("src-invalid-modifier").toString());
            }
            this.isAbstract = true;
            return this;
        }

        @Override
        public Class makeFinal() {
            if (this.isAbstract) {
                throw new IllegalArgumentException(_loc.get("src-invalid-modifier").toString());
            }
            this.isFinal = true;
            return this;
        }

        public Class markAsBean() {
            for (Field f : this.fields) {
                f.markAsBean();
            }
            return this;
        }

        public String getName() {
            return this.getType().getSimpleName();
        }

        public String getPackageName() {
            return this.getType().getPackageName();
        }

        public Field addField(String name, String type) {
            return this.addField(name, SourceCode.this.getOrCreateImport(type));
        }

        public Field addField(String f, ClassName type) {
            if (!SourceCode.isValidToken(f)) {
                throw new IllegalArgumentException(_loc.get("src-invalid-field", f).toString());
            }
            Field field = new Field(this, f, type);
            if (!this.fields.add(field)) {
                throw new IllegalArgumentException(_loc.get("src-duplicate-field", field, this).toString());
            }
            return field;
        }

        public Method addMethod(String m, String retType) {
            return this.addMethod(m, SourceCode.this.getOrCreateImport(retType));
        }

        protected Method addMethod(String m, ClassName retType) {
            if (SourceCode.isEmpty(m) || !SourceCode.isValidToken(m)) {
                throw new IllegalArgumentException(_loc.get("src-invalid-method", m).toString());
            }
            Method method = new Method(m, retType);
            if (!this.methods.add(method)) {
                throw new IllegalArgumentException(_loc.get("src-duplicate-method", method, this).toString());
            }
            return method;
        }

        public Constructor addConstructor() {
            Constructor c = new Constructor(this.type.simpleName);
            if (!this.constructors.add(c)) {
                throw new IllegalArgumentException(_loc.get("src-duplicate-constructor", c, this).toString());
            }
            return c;
        }

        @Override
        public void write(PrintWriter out, int tab) {
            super.write(out, tab);
            if (this.isAbstract) {
                out.append("abstract ");
            }
            if (this.isFinal) {
                out.append("final ");
            }
            out.print("class ");
            out.print(this.type.simpleName);
            SourceCode.writeList(out, SourceCode.BLANK, this.params, PARAMS_DELIMITER, false);
            if (this.superCls != null) {
                out.print(" extends " + this.superCls + SourceCode.SPACE);
            }
            SourceCode.writeList(out, "implements ", this.interfaces);
            out.println(SourceCode.SPACE + BLOCK_DELIMITER.start);
            for (Field field : this.fields) {
                field.write(out, 1);
            }
            for (Constructor ctor : this.constructors) {
                ctor.write(out, 1);
            }
            for (Method method : this.methods) {
                method.write(out, 1);
            }
            out.println(BLOCK_DELIMITER.end);
        }

        public String toString() {
            return this.getType().fullName;
        }
    }

    public abstract class Element<T>
    implements Comparable<Element<T>> {
        protected String name;
        protected ClassName type;
        protected ACCESS access;
        protected boolean isStatic;
        protected boolean isFinal;
        protected Comment comment;
        protected List<ClassName> params = new ArrayList<ClassName>();
        protected List<Annotation> annos = new ArrayList<Annotation>();

        protected Element(String name, ClassName type) {
            this.name = name;
            this.type = type;
        }

        public ClassName getType() {
            return this.type;
        }

        public Annotation addAnnotation(String a) {
            Annotation an = new Annotation(a);
            this.annos.add(an);
            return an;
        }

        public Element<T> addParameter(String param) {
            this.params.add(SourceCode.this.getOrCreateImport(param));
            return this;
        }

        @Override
        public int compareTo(Element<T> other) {
            return this.name.compareTo(other.name);
        }

        public T addComment(boolean inline, String ... lines) {
            if (this.comment == null) {
                this.comment = new Comment();
            }
            this.comment.makeInline(inline);
            for (String line : lines) {
                this.comment.append(line);
            }
            return (T)this;
        }

        public T makePublic() {
            this.access = ACCESS.PUBLIC;
            return (T)this;
        }

        public T makeProtected() {
            this.access = ACCESS.PROTECTED;
            return (T)this;
        }

        public T makePrivate() {
            this.access = ACCESS.PRIVATE;
            return (T)this;
        }

        public T makeStatic() {
            this.isStatic = true;
            return (T)this;
        }

        public T makeFinal() {
            this.isFinal = true;
            return (T)this;
        }

        public void write(PrintWriter out, int tab) {
            if (this.comment != null) {
                this.comment.write(out, tab);
            }
            for (Annotation a : this.annos) {
                a.write(out, tab);
            }
            SourceCode.tab(out, tab);
            if (this.access != null) {
                out.append(this.access.toString().toLowerCase() + SourceCode.SPACE);
            }
            if (this.isStatic) {
                out.append("static ");
            }
            if (this.isFinal) {
                out.append("final ");
            }
        }
    }

    public static enum ACCESS {
        PUBLIC,
        PROTECTED,
        PRIVATE;

    }
}

