/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.UnexpectedTypeException;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.Validate;
import org.apache.bval.jsr303.AnnotationConstraintBuilder;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.AppendValidation;
import org.apache.bval.jsr303.AppendValidationToBuilder;
import org.apache.bval.jsr303.AppendValidationToMeta;
import org.apache.bval.jsr303.ConstraintDefaults;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.jsr303.util.ConstraintDefinitionValidator;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.util.TypeUtils;
import org.apache.bval.jsr303.xml.MetaConstraint;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr303MetaBeanFactory
implements MetaBeanFactory {
    protected static final Logger log = LoggerFactory.getLogger(Jsr303MetaBeanFactory.class);
    protected static final String ANNOTATION_VALUE = "value";
    public static final String ANNOTATION_PAYLOAD = "payload";
    public static final String ANNOTATION_GROUPS = "groups";
    public static final String ANNOTATION_MESSAGE = "message";
    protected final ApacheFactoryContext factoryContext;

    public Jsr303MetaBeanFactory(ApacheFactoryContext factoryContext) {
        this.factoryContext = factoryContext;
    }

    private ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.factoryContext.getConstraintValidatorFactory();
    }

    private ConstraintDefaults getDefaultConstraints() {
        return this.factoryContext.getFactory().getDefaultConstraints();
    }

    public void buildMetaBean(MetaBean metabean) {
        try {
            Class beanClass = metabean.getBeanClass();
            this.processGroupSequence(beanClass, metabean);
            ArrayList classSequence = new ArrayList();
            ClassHelper.fillFullClassHierarchyAsList(classSequence, beanClass);
            for (int i = classSequence.size() - 1; i >= 0; --i) {
                Class eachClass = (Class)classSequence.get(i);
                this.processClass(eachClass, metabean);
                this.processGroupSequence(eachClass, metabean, "{GroupSequence:" + eachClass.getCanonicalName() + "}");
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException());
        }
    }

    private void processClass(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Field[] fields;
        if (!this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(beanClass)) {
            this.processAnnotations(null, beanClass, beanClass, null, new AppendValidationToMeta((FeaturesCapable)metabean));
        }
        for (Field field : fields = SecureActions.getDeclaredFields(beanClass)) {
            MetaProperty metaProperty = metabean.getProperty(field.getName());
            if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(field)) continue;
            if (metaProperty == null) {
                metaProperty = this.addMetaProperty(metabean, field.getName(), field.getType());
                this.processAnnotations(metaProperty, beanClass, field, (AccessStrategy)new FieldAccess(field), new AppendValidationToMeta((FeaturesCapable)metaProperty));
                continue;
            }
            this.processAnnotations(metaProperty, beanClass, field, (AccessStrategy)new FieldAccess(field), new AppendValidationToMeta((FeaturesCapable)metaProperty));
        }
        for (Method method : methods = SecureActions.getDeclaredMethods(beanClass)) {
            String propName = null;
            if (method.getParameterTypes().length == 0) {
                propName = MethodAccess.getPropertyName((Method)method);
            }
            if (propName != null) {
                if (this.factoryContext.getFactory().getAnnotationIgnores().isIgnoreAnnotations(method)) continue;
                MetaProperty metaProperty = metabean.getProperty(propName);
                if (metaProperty == null) {
                    metaProperty = this.addMetaProperty(metabean, propName, method.getReturnType());
                    this.processAnnotations(metaProperty, beanClass, method, (AccessStrategy)new MethodAccess(propName, method), new AppendValidationToMeta((FeaturesCapable)metaProperty));
                    continue;
                }
                this.processAnnotations(metaProperty, beanClass, method, (AccessStrategy)new MethodAccess(propName, method), new AppendValidationToMeta((FeaturesCapable)metaProperty));
                continue;
            }
            if (!this.hasValidationConstraintsDefined(method)) continue;
            throw new ValidationException("Property " + method.getName() + " does not follow javabean conventions.");
        }
        this.addXmlConstraints(beanClass, metabean);
    }

    protected boolean hasValidationConstraintsDefined(Method method) {
        Annotation annot;
        boolean ret = false;
        Annotation[] arr$ = method.getDeclaredAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(ret = this.hasValidationConstraintsDefined(annot = arr$[i$])); ++i$) {
        }
        return ret;
    }

    private boolean hasValidationConstraintsDefined(Annotation annot) {
        if (annot.annotationType().getAnnotation(Constraint.class) != null) {
            return true;
        }
        boolean ret = false;
        Object value = null;
        try {
            value = SecureActions.getAnnotationValue((Annotation)annot, (String)ANNOTATION_VALUE);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (value instanceof Annotation[]) {
            Annotation annot2;
            Annotation[] arr$ = (Annotation[])value;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(ret = this.hasValidationConstraintsDefined(annot2 = arr$[i$])); ++i$) {
            }
        }
        return ret;
    }

    private void addXmlConstraints(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        MetaProperty metaProperty;
        for (MetaConstraint<?, Annotation> meta : this.factoryContext.getFactory().getMetaConstraints(beanClass)) {
            if (meta.getAccessStrategy() == null) {
                metaProperty = null;
            } else {
                metaProperty = metabean.getProperty(meta.getAccessStrategy().getPropertyName());
                if (metaProperty == null) {
                    metaProperty = this.addMetaProperty(metabean, meta.getAccessStrategy().getPropertyName(), meta.getAccessStrategy().getJavaType());
                }
            }
            Class<ConstraintValidator<Annotation, ?>>[] validatorClasses = this.findConstraintValidatorClasses(meta.getAnnotation(), null);
            this.applyConstraint(meta.getAnnotation(), validatorClasses, metaProperty, beanClass, meta.getAccessStrategy(), new AppendValidationToMeta((FeaturesCapable)(metaProperty == null ? metabean : metaProperty)));
        }
        for (AccessStrategy access : this.factoryContext.getFactory().getValidAccesses(beanClass)) {
            metaProperty = metabean.getProperty(access.getPropertyName());
            if (metaProperty == null) {
                metaProperty = this.addMetaProperty(metabean, access.getPropertyName(), access.getJavaType());
            }
            this.processValid(metaProperty, access, new Class[0]);
        }
    }

    private MetaProperty addMetaProperty(MetaBean parentMetaBean, String propName, Type type) {
        MetaProperty metaProperty = new MetaProperty();
        metaProperty.setName(propName);
        metaProperty.setType(type);
        parentMetaBean.putProperty(propName, metaProperty);
        return metaProperty;
    }

    private boolean processAnnotations(MetaProperty prop, Class<?> owner, AnnotatedElement element, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        boolean changed = false;
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            changed |= this.processAnnotation(annotation, prop, owner, access, appender);
        }
        return changed;
    }

    private <A extends Annotation> boolean processAnnotation(A annotation, MetaProperty prop, Class<?> owner, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        if (annotation instanceof Valid) {
            return this.processValid(prop, access, new Class[0]);
        }
        if (annotation instanceof Validate) {
            return this.processValid(prop, access, ((Validate)annotation).groups());
        }
        Constraint vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        if (vcAnno != null) {
            ConstraintDefinitionValidator.validateConstraintDefinition(annotation);
            Class<ConstraintValidator<A, ?>>[] validatorClasses = this.findConstraintValidatorClasses(annotation, vcAnno);
            return this.applyConstraint(annotation, validatorClasses, prop, owner, access, appender);
        }
        Object result = SecureActions.getAnnotationValue(annotation, (String)ANNOTATION_VALUE);
        if (result != null && result instanceof Annotation[]) {
            boolean changed = false;
            for (Annotation each : (Annotation[])result) {
                changed |= this.processAnnotation(each, prop, owner, access, appender);
            }
            return changed;
        }
        return false;
    }

    protected <A extends Annotation> Class<? extends ConstraintValidator<A, ?>>[] findConstraintValidatorClasses(A annotation, Constraint vcAnno) {
        if (vcAnno == null) {
            vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Class<ConstraintValidator<? extends Annotation, ?>>[] validatorClasses = this.factoryContext.getFactory().getConstraintsCache().getConstraintValidators(annotationType);
        if (validatorClasses == null && (validatorClasses = vcAnno.validatedBy()).length == 0) {
            validatorClasses = this.getDefaultConstraints().getValidatorClasses(annotationType);
        }
        return validatorClasses;
    }

    private boolean processValid(MetaProperty prop, AccessStrategy access, Class<?> ... groups) {
        if (prop != null) {
            Object[] strategies = (AccessStrategy[])prop.getFeature("refCascade");
            prop.putFeature("refGroups", groups);
            if (strategies == null) {
                strategies = new AccessStrategy[]{access};
                prop.putFeature("refCascade", (Object)strategies);
            } else if (!ArrayUtils.contains((Object[])strategies, (Object)access)) {
                AccessStrategy[] strategies_new = new AccessStrategy[strategies.length + 1];
                System.arraycopy(strategies, 0, strategies_new, 0, strategies.length);
                strategies_new[strategies.length] = access;
                prop.putFeature("refCascade", (Object)strategies_new);
            }
            return true;
        }
        return false;
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean) {
        this.processGroupSequence(beanClass, metabean, "GroupSequence");
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean, String key) {
        Class<?>[] groupClasses;
        GroupSequence annotation = beanClass.getAnnotation(GroupSequence.class);
        ArrayList<Group> groupSeq = (ArrayList<Group>)metabean.getFeature(key);
        if (groupSeq == null) {
            groupSeq = new ArrayList<Group>(annotation == null ? 1 : annotation.value().length);
            metabean.putFeature(key, groupSeq);
        }
        if ((groupClasses = this.factoryContext.getFactory().getDefaultSequence(beanClass)) == null || groupClasses.length == 0) {
            if (annotation == null) {
                groupSeq.add(Group.DEFAULT);
                return;
            }
            groupClasses = annotation.value();
        }
        boolean containsDefault = false;
        for (Class<?> groupClass : groupClasses) {
            if (groupClass.getName().equals(beanClass.getName())) {
                groupSeq.add(Group.DEFAULT);
                containsDefault = true;
                continue;
            }
            if (groupClass.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' must not appear in @GroupSequence! Use '" + beanClass.getSimpleName() + ".class' instead.");
            }
            groupSeq.add(new Group(groupClass));
        }
        if (!containsDefault) {
            throw new GroupDefinitionException("Redefined default group sequence must contain " + beanClass.getName());
        }
        log.debug("Default group sequence for bean {} is: {}", (Object)beanClass.getName(), groupSeq);
    }

    protected <A extends Annotation> boolean applyConstraint(A annotation, Class<? extends ConstraintValidator<A, ?>>[] constraintClasses, MetaProperty prop, Class<?> owner, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        ConstraintValidator validator;
        if (constraintClasses != null && constraintClasses.length > 0) {
            Type type = this.determineTargetedType(owner, access);
            Map validatorTypes = TypeUtils.getValidatorsTypes(constraintClasses);
            ArrayList<Type> assignableTypes = new ArrayList<Type>(constraintClasses.length);
            this.fillAssignableTypes(type, validatorTypes.keySet(), assignableTypes);
            this.reduceAssignableTypes(assignableTypes);
            this.checkOneType(assignableTypes, type, owner, annotation, access);
            validator = this.getConstraintValidatorFactory().getInstance(validatorTypes.get(assignableTypes.get(0)));
            if (validator == null) {
                throw new ValidationException("Factory returned null validator for: " + validatorTypes.get(assignableTypes.get(0)));
            }
        } else {
            validator = null;
        }
        AnnotationConstraintBuilder<A> builder = new AnnotationConstraintBuilder<A>(constraintClasses, validator, annotation, owner, access);
        if (prop != null && prop.getParentMetaBean() != null) {
            MetaBean parentMetaBean = prop.getParentMetaBean();
            if (builder.getConstraintValidation().getOwner().isInterface() && parentMetaBean.getBeanClass() != builder.getConstraintValidation().getOwner() && builder.getConstraintValidation().getGroups().size() == 1 && builder.getConstraintValidation().getGroups().contains(Default.class)) {
                Set<Class<?>> groups = builder.getConstraintValidation().getGroups();
                groups.add(builder.getConstraintValidation().getOwner());
                builder.getConstraintValidation().setGroups(groups);
            }
        }
        if (appender instanceof AppendValidationToBuilder) {
            AppendValidationToBuilder avb = (AppendValidationToBuilder)appender;
            builder.getConstraintValidation().setGroups(avb.getInheritedGroups());
            builder.getConstraintValidation().setPayload(avb.getInheritedPayload());
        }
        this.processAnnotations(prop, owner, annotation.annotationType(), access, new AppendValidationToBuilder(builder));
        appender.append(builder.getConstraintValidation());
        return true;
    }

    private void checkOneType(List<Type> types, Type targetType, Class<?> owner, Annotation anno, AccessStrategy access) {
        if (types.isEmpty()) {
            StringBuilder buf = new StringBuilder().append("No validator could be found for type ").append(this.stringForType(targetType)).append(". See: @").append(anno.annotationType().getSimpleName()).append(" at ").append(this.stringForLocation(owner, access));
            throw new UnexpectedTypeException(buf.toString());
        }
        if (types.size() > 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("Ambiguous validators for type ");
            buf.append(this.stringForType(targetType));
            buf.append(". See: @").append(anno.annotationType().getSimpleName()).append(" at ").append(this.stringForLocation(owner, access));
            buf.append(". Validators are: ");
            boolean comma = false;
            for (Type each : types) {
                if (comma) {
                    buf.append(", ");
                }
                comma = true;
                buf.append(each);
            }
            throw new UnexpectedTypeException(buf.toString());
        }
    }

    private Type determineTargetedType(Class<?> owner, AccessStrategy access) {
        if (access == null) {
            return owner;
        }
        Type type = access.getJavaType();
        if (type == null) {
            return Object.class;
        }
        if (type instanceof Class) {
            type = ClassUtils.primitiveToWrapper((Class)((Class)type));
        }
        return type;
    }

    private String stringForType(Type clazz) {
        if (clazz instanceof Class) {
            if (((Class)clazz).isArray()) {
                return ((Class)clazz).getComponentType().getName() + "[]";
            }
            return ((Class)clazz).getName();
        }
        return clazz.toString();
    }

    private String stringForLocation(Class<?> owner, AccessStrategy access) {
        if (access != null) {
            return access.toString();
        }
        return owner.getName();
    }

    private void fillAssignableTypes(Type type, Set<Type> validatorsTypes, List<Type> suitableTypes) {
        for (Type validatorType : validatorsTypes) {
            if (!TypeUtils.isAssignable(validatorType, type) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
    }

    private void reduceAssignableTypes(List<Type> assignableTypes) {
        boolean removed;
        if (assignableTypes.size() <= 1) {
            return;
        }
        do {
            removed = false;
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                Type nextType = assignableTypes.get(i);
                if (TypeUtils.isAssignable(type, nextType)) {
                    assignableTypes.remove(0);
                    --i;
                    removed = true;
                    continue;
                }
                if (!TypeUtils.isAssignable(nextType, type)) continue;
                assignableTypes.remove(i--);
                removed = true;
            }
        } while (removed && assignableTypes.size() > 1);
    }
}

