/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.Service;
import org.apache.openejb.util.PropertiesService;

public class Server
implements Service {
    Properties props;
    private PropertiesService propertiesService;
    private static Server server;
    private static ServiceManager manager;

    public static Server getInstance() {
        if (server == null) {
            server = new Server();
        }
        return server;
    }

    public void init(Properties props) throws Exception {
        this.props = props;
        SystemInstance system = SystemInstance.get();
        File home = system.getHome().getDirectory();
        system.setProperty("openejb.deployments.classpath.include", ".*/" + home.getName() + "/lib/.*");
        system.setProperty("openejb.deployments.classpath.require.descriptor", "true");
        system.setProperty("openejb.deployments.classpath.filter.systemapps", "false");
        OpenEJB.init((Properties)props, (ApplicationServer)new ServerFederation());
        if (System.getProperty("openejb.nobanner") == null) {
            System.out.println("[init] OpenEJB Remote Server");
        }
        if (manager == null) {
            manager = ServiceManager.getManager();
        }
        manager.init();
    }

    public void init() throws Exception {
        OpenEJB.init((Properties)this.propertiesService.getProperties(), (ApplicationServer)new ServerFederation());
        if (!this.propertiesService.isSet("openejb.nobanner")) {
            System.out.println("[init] OpenEJB Remote Server");
        }
        manager.init();
    }

    public void start() throws Exception {
        manager.start();
    }

    public void stop() throws Exception {
        OpenEJB.destroy();
        manager.stop();
    }

    public void addService(URI uri) {
    }

    public void setServiceManager(ServiceManager serviceManager) {
        manager = serviceManager;
    }

    public void setPropertiesService(PropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public static class ServerServiceFactory {
        public ServerService createService(URI location) throws IOException {
            return null;
        }
    }
}

