/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleChartPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDrawingPagePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleRubyPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.OdfStylePropertySet;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfContainerElementBase;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfStyleBase
extends OdfContainerElementBase
implements OdfStylePropertySet,
Comparable {
    private static final long serialVersionUID = 8271282184913774000L;
    private HashMap<OdfStylePropertiesSet, OdfStylePropertiesBase> mPropertySetElementMap;
    private ArrayList<OdfStylableElement> mStyleUser;
    static HashMap<OdfName, OdfStylePropertiesSet> mStylePropertiesElementToSetMap = new HashMap();

    public OdfStyleBase(OdfFileDom ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public OdfStyleBase(OdfFileDom ownerDocument, OdfName aName) throws DOMException {
        super(ownerDocument, aName.getUri(), aName.getQName());
    }

    public void addStyleUser(OdfStylableElement user) {
        if (this.mStyleUser == null) {
            this.mStyleUser = new ArrayList();
        }
        this.mStyleUser.add(user);
    }

    public Map<OdfStyleProperty, String> getStyleProperties() {
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        OdfStyleFamily family = this.getFamily();
        if (family != null) {
            for (OdfStyleProperty property : family.getProperties()) {
                if (!this.hasProperty(property)) continue;
                result.put(property, this.getProperty(property));
            }
        }
        return result;
    }

    public Map<OdfStyleProperty, String> getStylePropertiesDeep() {
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        for (OdfStyleBase style = this; style != null; style = style.getParentStyle()) {
            OdfStyleFamily family = style.getFamily();
            if (family == null) continue;
            for (OdfStyleProperty property : family.getProperties()) {
                if (result.containsKey(property) || !style.hasProperty(property)) continue;
                result.put(property, style.getProperty(property));
            }
        }
        return result;
    }

    public void removeStyleUser(OdfStylableElement user) {
        if (this.mStyleUser != null) {
            this.mStyleUser.remove(user);
        }
    }

    public int getStyleUserCount() {
        return this.mStyleUser == null ? 0 : this.mStyleUser.size();
    }

    public Iterable<OdfStylableElement> getStyleUsers() {
        if (this.mStyleUser != null) {
            return this.mStyleUser;
        }
        return new ArrayList<OdfStylableElement>();
    }

    public String getFamilyName() {
        return this.getFamily().getName();
    }

    public OdfStylePropertiesBase getPropertiesElement(OdfStylePropertiesSet set) {
        if (this.mPropertySetElementMap != null) {
            return this.mPropertySetElementMap.get((Object)set);
        }
        return null;
    }

    public OdfStylePropertiesBase getOrCreatePropertiesElement(OdfStylePropertiesSet set) {
        OdfStylePropertiesBase properties = null;
        if (this.mPropertySetElementMap != null) {
            properties = this.mPropertySetElementMap.get((Object)set);
        }
        if (properties == null) {
            for (Map.Entry<OdfName, OdfStylePropertiesSet> entry : mStylePropertiesElementToSetMap.entrySet()) {
                if (!entry.getValue().equals((Object)set)) continue;
                properties = (OdfStylePropertiesBase)((OdfFileDom)this.ownerDocument).createElementNS(entry.getKey());
                if (this.getFirstChild() == null) {
                    this.appendChild((Node)((Object)properties));
                    break;
                }
                Object beforeNode = null;
                if (set.equals((Object)OdfStylePropertiesSet.GraphicProperties)) {
                    beforeNode = OdfElement.findFirstChildNode(StyleParagraphPropertiesElement.class, (Node)((Object)this));
                    if (beforeNode == null) {
                        beforeNode = OdfElement.findFirstChildNode(StyleTextPropertiesElement.class, (Node)((Object)this));
                    }
                } else if (set.equals((Object)OdfStylePropertiesSet.ParagraphProperties)) {
                    beforeNode = OdfElement.findFirstChildNode(StyleTextPropertiesElement.class, (Node)((Object)this));
                } else if (!set.equals((Object)OdfStylePropertiesSet.TextProperties)) {
                    beforeNode = this.getFirstChild();
                }
                if (beforeNode == null) {
                    for (beforeNode = this.getFirstChild(); beforeNode != null && (beforeNode.getNodeType() != 1 || beforeNode instanceof OdfStylePropertiesBase); beforeNode = beforeNode.getNextSibling()) {
                    }
                }
                this.insertBefore((Node)((Object)properties), (Node)beforeNode);
                break;
            }
        }
        return properties;
    }

    @Override
    public String getProperty(OdfStyleProperty prop) {
        String value = null;
        OdfStylePropertiesBase properties = this.getPropertiesElement(prop.getPropertySet());
        if (properties != null && properties.hasAttributeNS(prop.getName().getUri(), prop.getName().getLocalName())) {
            return properties.getOdfAttribute(prop.getName()).getValue();
        }
        OdfStyleBase parent = this.getParentStyle();
        if (parent != null) {
            return parent.getProperty(prop);
        }
        return value;
    }

    @Override
    public boolean hasProperty(OdfStyleProperty prop) {
        OdfStylePropertiesBase properties;
        if (this.mPropertySetElementMap != null && (properties = this.mPropertySetElementMap.get((Object)prop.getPropertySet())) != null) {
            return properties.hasAttributeNS(prop.getName().getUri(), prop.getName().getLocalName());
        }
        return false;
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refChild) {
        OdfStylePropertiesSet set;
        if (node instanceof OdfStylePropertiesBase && (set = mStylePropertiesElementToSetMap.get(node.getOdfName())) != null) {
            if (this.mPropertySetElementMap == null) {
                this.mPropertySetElementMap = new HashMap();
            }
            this.mPropertySetElementMap.put(set, (OdfStylePropertiesBase)node);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        OdfStylePropertiesSet set;
        if (this.mPropertySetElementMap != null && node instanceof OdfStylePropertiesBase && (set = mStylePropertiesElementToSetMap.get(node.getOdfName())) != null) {
            this.mPropertySetElementMap.remove((Object)set);
        }
    }

    @Override
    public Map<OdfStyleProperty, String> getProperties(Set<OdfStyleProperty> properties) {
        HashMap<OdfStyleProperty, String> map = new HashMap<OdfStyleProperty, String>();
        for (OdfStyleProperty property : properties) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    @Override
    public Set<OdfStyleProperty> getStrictProperties() {
        return this.getFamily().getProperties();
    }

    @Override
    public void removeProperty(OdfStyleProperty property) {
        OdfStylePropertiesBase properties;
        if (this.mPropertySetElementMap != null && (properties = this.mPropertySetElementMap.get((Object)property.getPropertySet())) != null) {
            properties.removeAttributeNS(property.getName().getUri(), property.getName().getLocalName());
        }
    }

    @Override
    public void setProperties(Map<OdfStyleProperty, String> properties) {
        for (Map.Entry<OdfStyleProperty, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(OdfStyleProperty property, String value) {
        OdfStylePropertiesBase properties = this.getOrCreatePropertiesElement(property.getPropertySet());
        if (properties != null) {
            OdfAttribute propertyAttr = ((OdfFileDom)this.ownerDocument).createAttributeNS(property.getName());
            properties.setOdfAttribute(propertyAttr);
            propertyAttr.setValue(value);
        }
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (!(obj instanceof OdfStyleBase)) {
            if (obj == null) {
                throw new ClassCastException("The object to be compared is null!");
            }
            throw new ClassCastException("The object to be compared is not a style!");
        }
        OdfStyleBase compare = (OdfStyleBase)obj;
        int c = OdfStyleBase.compareNodes((Node)((Object)this), (Node)((Object)compare));
        return c;
    }

    private static int compareNodes(Node compare1, Node compare2) {
        int attr_count2;
        int c = 0;
        c = compare1.getLocalName().compareTo(compare2.getLocalName());
        if (c != 0) {
            return c;
        }
        c = compare1.getNamespaceURI().compareTo(compare2.getNamespaceURI());
        if (c != 0) {
            return c;
        }
        int attr_count1 = compare1.getAttributes() != null ? compare1.getAttributes().getLength() : 0;
        int n = attr_count2 = compare2.getAttributes() != null ? compare2.getAttributes().getLength() : 0;
        if (attr_count1 != attr_count2) {
            return attr_count1 < attr_count2 ? -1 : 1;
        }
        SortedMap<String, String> attr1 = OdfStyleBase.getSortedAttributes(compare1);
        SortedMap<String, String> attr2 = OdfStyleBase.getSortedAttributes(compare2);
        Iterator<String> keySet1Iter = attr1.keySet().iterator();
        Iterator<String> keySet2Iter = attr2.keySet().iterator();
        while (keySet1Iter.hasNext()) {
            String attrValue2;
            String key2;
            String key1 = keySet1Iter.next();
            c = key1.compareTo(key2 = keySet2Iter.next());
            if (c != 0) {
                return c;
            }
            String attrValue1 = (String)attr1.get(key1);
            c = attrValue1.compareTo(attrValue2 = (String)attr2.get(key1));
            if (c == 0) continue;
            return c;
        }
        ArrayList<Node> nodes1 = OdfStyleBase.getNonEmptyChildNodes(compare1);
        ArrayList<Node> nodes2 = OdfStyleBase.getNonEmptyChildNodes(compare2);
        if (nodes1.size() != nodes2.size()) {
            return nodes1.size() < nodes2.size() ? -1 : 1;
        }
        Iterator<Node> iter1 = nodes1.iterator();
        Iterator<Node> iter2 = nodes2.iterator();
        while (iter1.hasNext()) {
            Node child2;
            Node child1 = iter1.next();
            c = OdfStyleBase.compareNodes(child1, child2 = iter2.next());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static SortedMap<String, String> getSortedAttributes(Node node) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node cur = attrs.item(i);
            String namespace = cur.getNamespaceURI();
            String local = cur.getLocalName();
            if (local.equals("name") && namespace.equals(OdfDocumentNamespace.STYLE.getUri())) continue;
            ret.put(namespace + ":" + local, ((Attr)cur).getValue());
        }
        return ret;
    }

    private static ArrayList<Node> getNonEmptyChildNodes(Node node) {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur.getNodeType() == 3 && cur.getNodeValue().trim().length() == 0) continue;
            ret.add(cur);
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null ? this.compareTo(obj) == 0 : false;
    }

    public int hashCode() {
        return 413 + (this.mPropertySetElementMap != null ? this.mPropertySetElementMap.hashCode() : 0);
    }

    public OdfStyleFamily getFamily() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OdfStyleBase getParentStyle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        mStylePropertiesElementToSetMap.put(StyleChartPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ChartProperties);
        mStylePropertiesElementToSetMap.put(StyleDrawingPagePropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.DrawingPageProperties);
        mStylePropertiesElementToSetMap.put(StyleGraphicPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.GraphicProperties);
        mStylePropertiesElementToSetMap.put(StyleHeaderFooterPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.HeaderFooterProperties);
        mStylePropertiesElementToSetMap.put(StyleListLevelPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ListLevelProperties);
        mStylePropertiesElementToSetMap.put(StylePageLayoutPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.PageLayoutProperties);
        mStylePropertiesElementToSetMap.put(StyleParagraphPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ParagraphProperties);
        mStylePropertiesElementToSetMap.put(StyleRubyPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.RubyProperties);
        mStylePropertiesElementToSetMap.put(StyleSectionPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.SectionProperties);
        mStylePropertiesElementToSetMap.put(StyleTableCellPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableCellProperties);
        mStylePropertiesElementToSetMap.put(StyleTableColumnPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableColumnProperties);
        mStylePropertiesElementToSetMap.put(StyleTablePropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableProperties);
        mStylePropertiesElementToSetMap.put(StyleTableRowPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableRowProperties);
        mStylePropertiesElementToSetMap.put(StyleTextPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TextProperties);
    }
}

