/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.context.FacesContext;

public class MockMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = 5694105394290316715L;
    private String[] elements = null;
    private Class expectedType = null;
    private String expression = null;
    private Class[] signature = null;

    public MockMethodExpression(String expression, Class[] signature, Class expectedType) {
        if (expression == null) {
            throw new NullPointerException("Expression string cannot be null");
        }
        this.expression = expression;
        this.signature = signature;
        this.expectedType = expectedType;
        this.parse();
    }

    public boolean equals(Object obj) {
        if (obj != null & obj instanceof MethodExpression) {
            return this.expression.equals(((MethodExpression)obj).getExpressionString());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean isLiteralText() {
        return this.expression.indexOf("${") < 0 && this.expression.indexOf("#{") < 0;
    }

    public MethodInfo getMethodInfo(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new MethodInfo(this.elements[this.elements.length - 1], this.expectedType, this.signature);
    }

    public Object invoke(ELContext context, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isLiteralText()) {
            return this.expression;
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        ELResolver resolver = fcontext.getApplication().getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length - 1; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        try {
            Method method = base.getClass().getMethod(this.elements[this.elements.length - 1], this.signature);
            Object result = method.invoke(base, params);
            return fcontext.getApplication().getExpressionFactory().coerceToType(result, this.expectedType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse() {
        if (this.isLiteralText()) {
            this.elements = new String[0];
            return;
        }
        if (!this.expression.startsWith("${") && !this.expression.startsWith("#{")) throw new IllegalArgumentException(this.expression);
        if (!this.expression.endsWith("}")) throw new IllegalArgumentException(this.expression);
        String temp = this.expression.substring(2, this.expression.length() - 1).replaceAll(" ", "");
        ArrayList<String> names = new ArrayList<String>();
        while (temp.length() > 0) {
            int period = temp.indexOf(".");
            if (period >= 0) {
                names.add(temp.substring(0, period));
                temp = temp.substring(period + 1);
                continue;
            }
            names.add(temp);
            temp = "";
        }
        this.elements = names.toArray(new String[names.size()]);
    }
}

