/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.repository.RepositorySystem;

final class SurefireDependencyResolver {
    static final String PROVIDER_GROUP_ID = "org.apache.maven.surefire";
    private static final String[] PROVIDER_CLASSPATH_ORDER = new String[]{"surefire-junit3", "surefire-junit4", "surefire-junit47", "surefire-testng", "surefire-junit-platform", "surefire-api", "surefire-logger-api", "common-java5", "common-junit3", "common-junit4", "common-junit48", "common-testng-utils"};
    private final RepositorySystem repositorySystem;
    private final ArtifactFactory artifactFactory;
    private final ConsoleLogger log;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final String pluginName;

    SurefireDependencyResolver(RepositorySystem repositorySystem, ArtifactFactory artifactFactory, ConsoleLogger log, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, String pluginName) {
        this.repositorySystem = repositorySystem;
        this.artifactFactory = artifactFactory;
        this.log = log;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.pluginName = pluginName;
    }

    static boolean isWithinVersionSpec(@Nullable Artifact artifact, @Nonnull String versionSpec) {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException | OverConstrainedVersionException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    ArtifactResolutionResult resolveArtifact(Artifact providerArtifact) {
        return this.resolveArtifact(providerArtifact, null);
    }

    private ArtifactResolutionResult resolveArtifact(Artifact providerArtifact, @Nullable Artifact excludeArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(providerArtifact).setRemoteRepositories(this.remoteRepositories).setLocalRepository(this.localRepository).setResolveTransitively(true);
        if (excludeArtifact != null) {
            String pattern = excludeArtifact.getGroupId() + ":" + excludeArtifact.getArtifactId();
            request.setCollectionFilter((ArtifactFilter)new ExcludesArtifactFilter(Collections.singletonList(pattern)));
        }
        return this.repositorySystem.resolve(request);
    }

    @Nonnull
    Set<Artifact> getProviderClasspath(String providerArtifactId, String providerVersion) {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact(PROVIDER_GROUP_ID, providerArtifactId, VersionRange.createFromVersion((String)providerVersion), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(providerArtifact);
        if (this.log.isDebugEnabled()) {
            for (Artifact artifact : result.getArtifacts()) {
                String artifactPath = artifact.getFile().getAbsolutePath();
                String scope = artifact.getScope();
                this.log.debug("Adding to " + this.pluginName + " test classpath: " + artifactPath + " Scope: " + scope);
            }
        }
        return SurefireDependencyResolver.orderProviderArtifacts(result.getArtifacts());
    }

    Set<Artifact> addProviderToClasspath(Map<String, Artifact> pluginArtifactMap, Artifact mojoPluginArtifact, Artifact surefireCommon, Artifact surefireApi, Artifact surefireLoggerApi) {
        LinkedHashSet<Artifact> providerArtifacts = new LinkedHashSet<Artifact>();
        ArtifactResolutionResult artifactResolutionResult = this.resolveArtifact(mojoPluginArtifact);
        for (Artifact artifact : pluginArtifactMap.values()) {
            if (artifactResolutionResult.getArtifacts().contains(artifact)) continue;
            providerArtifacts.add(artifact);
            for (Artifact dependency : this.resolveArtifact(artifact).getArtifacts()) {
                String groupId = dependency.getGroupId();
                String artifactId = dependency.getArtifactId();
                if (groupId.equals(surefireCommon.getGroupId()) && artifactId.equals(surefireCommon.getArtifactId())) {
                    providerArtifacts.add(surefireCommon);
                    continue;
                }
                if (groupId.equals(surefireApi.getGroupId()) && artifactId.equals(surefireApi.getArtifactId())) {
                    providerArtifacts.add(surefireApi);
                    continue;
                }
                if (!groupId.equals(surefireLoggerApi.getGroupId()) || !artifactId.equals(surefireLoggerApi.getArtifactId())) continue;
                providerArtifacts.add(surefireLoggerApi);
            }
        }
        return SurefireDependencyResolver.orderProviderArtifacts(providerArtifacts);
    }

    private static Set<Artifact> orderProviderArtifacts(Set<Artifact> providerArtifacts) {
        LinkedHashSet<Artifact> orderedProviderArtifacts = new LinkedHashSet<Artifact>();
        for (String order : PROVIDER_CLASSPATH_ORDER) {
            Iterator<Artifact> providerArtifactsIt = providerArtifacts.iterator();
            while (providerArtifactsIt.hasNext()) {
                Artifact providerArtifact = providerArtifactsIt.next();
                if (!providerArtifact.getArtifactId().equals(order)) continue;
                orderedProviderArtifacts.add(providerArtifact);
                providerArtifactsIt.remove();
            }
        }
        orderedProviderArtifacts.addAll(providerArtifacts);
        return orderedProviderArtifacts;
    }
}

