/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.util.FilenameUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.io.DisabledOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGitUtils {
    private JGitUtils() {
    }

    public static void closeRepo(Git git) {
        if (git != null && git.getRepository() != null) {
            git.getRepository().close();
        }
    }

    public static ProgressMonitor getMonitor(ScmLogger logger) {
        return new TextProgressMonitor();
    }

    public static CredentialsProvider prepareSession(ScmLogger logger, Git git, GitScmProviderRepository repository) {
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", "origin", "url", repository.getFetchUrl());
        config.setString("remote", "origin", "pushURL", repository.getPushUrl());
        String password = StringUtils.isNotBlank((String)repository.getPassword()) ? repository.getPassword().trim() : "no-pwd-defined";
        logger.info("fetch url: " + repository.getFetchUrl().replace(password, "******"));
        logger.info("push url: " + repository.getPushUrl().replace(password, "******"));
        return JGitUtils.getCredentials(repository);
    }

    public static CredentialsProvider getCredentials(GitScmProviderRepository repository) {
        if (StringUtils.isNotBlank((String)repository.getUser()) && StringUtils.isNotBlank((String)repository.getPassword())) {
            return new UsernamePasswordCredentialsProvider(repository.getUser().trim(), repository.getPassword().trim());
        }
        return null;
    }

    public static Iterable<PushResult> push(ScmLogger logger, Git git, GitScmProviderRepository repo, RefSpec refSpec) throws GitAPIException, InvalidRemoteException, TransportException {
        CredentialsProvider credentials = JGitUtils.prepareSession(logger, git, repo);
        Iterable pushResultList = ((PushCommand)git.push().setCredentialsProvider(credentials)).setRefSpecs(new RefSpec[]{refSpec}).call();
        for (PushResult pushResult : pushResultList) {
            Collection ru = pushResult.getRemoteUpdates();
            for (RemoteRefUpdate remoteRefUpdate : ru) {
                logger.info(remoteRefUpdate.getStatus() + " - " + remoteRefUpdate.toString());
            }
        }
        return pushResultList;
    }

    public static boolean hasCommits(Repository repo) {
        if (repo != null && repo.getDirectory().exists()) {
            return new File(repo.getDirectory(), "objects").list().length > 2 || new File(repo.getDirectory(), "objects/pack").list().length > 0;
        }
        return false;
    }

    public static List<ScmFile> getFilesInCommit(Repository repository, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<ScmFile> list = new ArrayList<ScmFile>();
        if (JGitUtils.hasCommits(repository)) {
            RevWalk rw = new RevWalk(repository);
            RevCommit realParant = commit.getParentCount() > 0 ? commit.getParent(0) : commit;
            RevCommit parent = rw.parseCommit((AnyObjectId)realParant.getId());
            DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            df.setRepository(repository);
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(true);
            List diffs = df.scan(parent.getTree(), commit.getTree());
            for (DiffEntry diff : diffs) {
                list.add(new ScmFile(diff.getNewPath(), ScmFileStatus.CHECKED_IN));
            }
            rw.release();
        }
        return list;
    }

    public static ScmFileStatus getScmFileStatus(DiffEntry.ChangeType changeType) {
        switch (changeType) {
            case ADD: {
                return ScmFileStatus.ADDED;
            }
            case MODIFY: {
                return ScmFileStatus.MODIFIED;
            }
            case DELETE: {
                return ScmFileStatus.DELETED;
            }
            case RENAME: {
                return ScmFileStatus.RENAMED;
            }
            case COPY: {
                return ScmFileStatus.COPIED;
            }
        }
        return ScmFileStatus.UNKNOWN;
    }

    public static List<ScmFile> addAllFiles(Git git, ScmFileSet fileSet) throws GitAPIException, NoFilepatternException {
        URI baseUri = fileSet.getBasedir().toURI();
        AddCommand add = git.add();
        for (File file : fileSet.getFileList()) {
            if (!file.isAbsolute()) {
                file = new File(fileSet.getBasedir().getPath(), file.getPath());
            }
            if (!file.exists()) continue;
            String path = JGitUtils.relativize(baseUri, file);
            add.addFilepattern(path);
            add.addFilepattern(file.getAbsolutePath());
        }
        add.call();
        Status status = git.status().call();
        HashSet allInIndex = new HashSet();
        allInIndex.addAll(status.getAdded());
        allInIndex.addAll(status.getChanged());
        ArrayList<ScmFile> addedFiles = new ArrayList<ScmFile>(allInIndex.size());
        for (String entry : allInIndex) {
            ScmFile scmfile = new ScmFile(entry, ScmFileStatus.ADDED);
            Iterator itfl = fileSet.getFileList().iterator();
            while (itfl.hasNext()) {
                String path = JGitUtils.relativize(baseUri, (File)itfl.next());
                if (!FilenameUtils.normalizeFilename((String)path).equals(FilenameUtils.normalizeFilename((String)scmfile.getPath()))) continue;
                addedFiles.add(scmfile);
            }
        }
        return addedFiles;
    }

    private static String relativize(URI baseUri, File f) {
        String path = f.getPath();
        if (f.isAbsolute()) {
            path = baseUri.relativize(new File(path).toURI()).getPath();
        }
        return path;
    }

    public static List<RevCommit> getRevCommits(Repository repo, RevSort[] sortings, String fromRev, String toRev, final Date fromDate, final Date toDate, int maxLines) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        RevCommit real;
        RevCommit c;
        ObjectId toRevId;
        ArrayList<RevCommit> revs = new ArrayList<RevCommit>();
        RevWalk walk = new RevWalk(repo);
        ObjectId fromRevId = fromRev != null ? repo.resolve(fromRev) : null;
        ObjectId objectId = toRevId = toRev != null ? repo.resolve(toRev) : null;
        if (sortings == null || sortings.length == 0) {
            sortings = new RevSort[]{RevSort.TOPO, RevSort.COMMIT_TIME_DESC};
        }
        for (RevSort s : sortings) {
            walk.sort(s, true);
        }
        if (fromDate != null && toDate != null) {
            walk.setRevFilter(new RevFilter(){

                public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
                    int cmtTime = cmit.getCommitTime();
                    return (long)cmtTime >= fromDate.getTime() / 1000L && (long)cmtTime <= toDate.getTime() / 1000L;
                }

                public RevFilter clone() {
                    return this;
                }
            });
        } else {
            if (fromDate != null) {
                walk.setRevFilter(CommitTimeRevFilter.after((Date)fromDate));
            }
            if (toDate != null) {
                walk.setRevFilter(CommitTimeRevFilter.before((Date)toDate));
            }
        }
        if (fromRevId != null) {
            c = walk.parseCommit((AnyObjectId)fromRevId);
            c.add(RevFlag.UNINTERESTING);
            RevCommit real2 = walk.parseCommit((AnyObjectId)c);
            walk.markUninteresting(real2);
        }
        if (toRevId != null) {
            c = walk.parseCommit((AnyObjectId)toRevId);
            c.remove(RevFlag.UNINTERESTING);
            real = walk.parseCommit((AnyObjectId)c);
            walk.markStart(real);
        } else {
            ObjectId head = repo.resolve("HEAD");
            if (head == null) {
                throw new RuntimeException("Cannot resolve HEAD");
            }
            real = walk.parseCommit((AnyObjectId)head);
            walk.markStart(real);
        }
        int n = 0;
        for (RevCommit c2 : walk) {
            if (maxLines != -1 && ++n > maxLines) break;
            revs.add(c2);
        }
        return revs;
    }
}

