/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgCommand;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.changelog.HgChangeLogCommand;
import org.apache.maven.scm.provider.hg.command.diff.HgDiffConsumer;
import org.codehaus.plexus.util.StringUtils;

public class HgUpdateCommand
extends AbstractUpdateCommand
implements HgCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion tag) throws ScmException {
        File workingDir = fileSet.getBasedir();
        String[] update_cmd = new String[]{"pull", "-r", tag != null && !StringUtils.isEmpty((String)tag.getName()) ? tag.getName() : "tip"};
        ScmResult updateResult = HgUtils.execute(new HgConsumer(this.getLogger()), this.getLogger(), workingDir, update_cmd);
        if (!updateResult.isSuccess()) {
            return new UpdateScmResult(null, null, updateResult);
        }
        int currentRevision = HgUtils.getCurrentRevisionNumber(this.getLogger(), workingDir);
        int previousRevision = currentRevision - 1;
        String[] diffCmd = new String[]{"diff", "-r", "" + previousRevision};
        HgDiffConsumer diffConsumer = new HgDiffConsumer(this.getLogger(), workingDir);
        ScmResult diffResult = HgUtils.execute(diffConsumer, this.getLogger(), workingDir, diffCmd);
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        ArrayList changes = new ArrayList();
        List diffFiles = diffConsumer.getChangedFiles();
        Map diffChanges = diffConsumer.getDifferences();
        Iterator it = diffFiles.iterator();
        while (it.hasNext()) {
            ScmFile file = (ScmFile)it.next();
            changes.add(diffChanges.get(file.getPath()));
            if (file.getStatus() == ScmFileStatus.MODIFIED) {
                updatedFiles.add(new ScmFile(file.getPath(), ScmFileStatus.PATCHED));
                continue;
            }
            updatedFiles.add(file);
        }
        return new UpdateScmResultWithRevision(updatedFiles, changes, String.valueOf(currentRevision), diffResult);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        HgChangeLogCommand command = new HgChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

