/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarCommand;
import org.apache.maven.scm.provider.bazaar.command.changelog.BazaarChangeLogConsumer;

public class BazaarChangeLogCommand
extends AbstractChangeLogCommand
implements BazaarCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        String[] cmd = new String[]{"log", "--verbose"};
        BazaarChangeLogConsumer consumer = new BazaarChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = BazaarUtils.execute(consumer, this.getLogger(), fileSet.getBasedir(), cmd);
        List logEntries = consumer.getModifications();
        ArrayList<ChangeSet> inRangeAndValid = new ArrayList<ChangeSet>();
        startDate = startDate == null ? new Date(0L) : startDate;
        endDate = endDate == null ? new Date() : endDate;
        Iterator it = logEntries.iterator();
        while (it.hasNext()) {
            ChangeSet change = (ChangeSet)it.next();
            if (change.getFiles().size() <= 0 || change.getDate().before(startDate) || change.getDate().after(endDate)) continue;
            inRangeAndValid.add(change);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(inRangeAndValid, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }
}

