/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.scm.IdentifiedScm;

public class ReleaseUtils {
    private static final String DEVELOPMENT_KEY = "dev";
    private static final String RELEASE_KEY = "rel";

    private ReleaseUtils() {
    }

    public static ReleaseDescriptorBuilder.BuilderReleaseDescriptor buildReleaseDescriptor(ReleaseDescriptorBuilder builder) {
        return builder.build();
    }

    public static void copyPropertiesToReleaseDescriptor(Properties properties, ReleaseDescriptorBuilder builder) {
        if (properties.containsKey("completedPhase")) {
            builder.setCompletedPhase(properties.getProperty("completedPhase"));
        }
        if (properties.containsKey("commitByProject")) {
            builder.setCommitByProject(Boolean.parseBoolean(properties.getProperty("commitByProject")));
        }
        if (properties.containsKey("scm.id")) {
            builder.setScmId(properties.getProperty("scm.id"));
        }
        if (properties.containsKey("scm.url")) {
            builder.setScmSourceUrl(properties.getProperty("scm.url"));
        }
        if (properties.containsKey("scm.username")) {
            builder.setScmUsername(properties.getProperty("scm.username"));
        }
        if (properties.containsKey("scm.password")) {
            builder.setScmPassword(properties.getProperty("scm.password"));
        }
        if (properties.containsKey("scm.privateKey")) {
            builder.setScmPrivateKey(properties.getProperty("scm.privateKey"));
        }
        if (properties.containsKey("scm.passphrase")) {
            builder.setScmPrivateKeyPassPhrase(properties.getProperty("scm.passphrase"));
        }
        if (properties.containsKey("scm.tagBase")) {
            builder.setScmTagBase(properties.getProperty("scm.tagBase"));
        }
        if (properties.containsKey("scm.tagNameFormat")) {
            builder.setScmTagNameFormat(properties.getProperty("scm.tagNameFormat"));
        }
        if (properties.containsKey("scm.branchBase")) {
            builder.setScmBranchBase(properties.getProperty("scm.branchBase"));
        }
        if (properties.containsKey("scm.tag")) {
            builder.setScmReleaseLabel(properties.getProperty("scm.tag"));
        }
        if (properties.containsKey("scm.commentPrefix")) {
            builder.setScmCommentPrefix(properties.getProperty("scm.commentPrefix"));
        }
        if (properties.containsKey("scm.developmentCommitComment")) {
            builder.setScmDevelopmentCommitComment(properties.getProperty("scm.developmentCommitComment"));
        }
        if (properties.containsKey("scm.releaseCommitComment")) {
            builder.setScmReleaseCommitComment(properties.getProperty("scm.releaseCommitComment"));
        }
        if (properties.containsKey("scm.branchCommitComment")) {
            builder.setScmBranchCommitComment(properties.getProperty("scm.branchCommitComment"));
        }
        if (properties.containsKey("scm.rollbackCommitComment")) {
            builder.setScmRollbackCommitComment(properties.getProperty("scm.rollbackCommitComment"));
        }
        if (properties.containsKey("exec.additionalArguments")) {
            builder.setAdditionalArguments(properties.getProperty("exec.additionalArguments"));
        }
        if (properties.containsKey("exec.pomFileName")) {
            builder.setPomFileName(properties.getProperty("exec.pomFileName"));
        }
        if (properties.containsKey("exec.activateProfiles")) {
            builder.setActivateProfiles(Arrays.asList(properties.getProperty("exec.activateProfiles").split(",")));
        }
        if (properties.containsKey("preparationGoals")) {
            builder.setPreparationGoals(properties.getProperty("preparationGoals"));
        }
        if (properties.containsKey("completionGoals")) {
            builder.setCompletionGoals(properties.getProperty("completionGoals"));
        }
        if (properties.containsKey("projectVersionPolicyId")) {
            builder.setProjectVersionPolicyId(properties.getProperty("projectVersionPolicyId"));
        }
        if (properties.containsKey("projectNamingPolicyId")) {
            builder.setProjectNamingPolicyId(properties.getProperty("projectNamingPolicyId"));
        }
        if (properties.containsKey("releaseStrategyId")) {
            builder.setReleaseStrategyId(properties.getProperty("releaseStrategyId"));
        }
        if (properties.containsKey("exec.snapshotReleasePluginAllowed")) {
            String snapshotReleasePluginAllowedStr = properties.getProperty("exec.snapshotReleasePluginAllowed");
            builder.setSnapshotReleasePluginAllowed(Boolean.parseBoolean(snapshotReleasePluginAllowedStr));
        }
        if (properties.containsKey("remoteTagging")) {
            String remoteTaggingStr = properties.getProperty("remoteTagging");
            builder.setRemoteTagging(Boolean.parseBoolean(remoteTaggingStr));
        }
        if (properties.containsKey("pinExternals")) {
            String pinExternals = properties.getProperty("pinExternals");
            builder.setPinExternals(Boolean.parseBoolean(pinExternals));
        }
        if (properties.containsKey("pushChanges")) {
            String pushChanges = properties.getProperty("pushChanges");
            builder.setPushChanges(Boolean.parseBoolean(pushChanges));
        }
        if (properties.containsKey("workItem")) {
            builder.setWorkItem(properties.getProperty("workItem"));
        }
        if (properties.containsKey("autoResolveSnapshots")) {
            String resolve = properties.getProperty("autoResolveSnapshots");
            builder.setAutoResolveSnapshots(resolve);
        }
        ReleaseUtils.loadResolvedDependencies(properties, builder);
        for (Object o : properties.keySet()) {
            int index;
            String property = (String)o;
            if (property.startsWith("project.rel.")) {
                builder.addReleaseVersion(property.substring("project.rel.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("project.dev.")) {
                builder.addDevelopmentVersion(property.substring("project.dev.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("dependency.rel.")) {
                builder.addDependencyReleaseVersion(property.substring("dependency.rel.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("dependency.dev.")) {
                builder.addDependencyDevelopmentVersion(property.substring("dependency.dev.".length()), properties.getProperty(property));
                continue;
            }
            if (!property.startsWith("project.scm.") || (index = property.lastIndexOf(46)) <= "project.scm.".length()) continue;
            String key = property.substring("project.scm.".length(), index);
            if (builder.build().getOriginalScmInfo(key) != null) continue;
            if (properties.getProperty("project.scm." + key + ".empty") != null) {
                builder.addOriginalScmInfo(key, null);
                continue;
            }
            IdentifiedScm scm = new IdentifiedScm();
            scm.setConnection(properties.getProperty("project.scm." + key + ".connection"));
            scm.setDeveloperConnection(properties.getProperty("project.scm." + key + ".developerConnection"));
            scm.setUrl(properties.getProperty("project.scm." + key + ".url"));
            scm.setTag(properties.getProperty("project.scm." + key + ".tag"));
            scm.setId(properties.getProperty("project.scm." + key + ".id"));
            builder.addOriginalScmInfo(key, scm);
        }
    }

    private static void loadResolvedDependencies(Properties prop, ReleaseDescriptorBuilder builder) {
        Set<Map.Entry<Object, Object>> entries = prop.entrySet();
        for (Map.Entry<Object, Object> currentEntry : entries) {
            String versionType;
            int endIndex;
            String propertyName = (String)currentEntry.getKey();
            if (!propertyName.startsWith("dependency.")) continue;
            int startIndex = "dependency.".length();
            if (propertyName.contains(".development")) {
                endIndex = propertyName.lastIndexOf(".development");
                versionType = DEVELOPMENT_KEY;
            } else {
                if (!propertyName.contains(".release")) continue;
                endIndex = propertyName.lastIndexOf(".release");
                versionType = RELEASE_KEY;
            }
            String artifactVersionlessKey = propertyName.substring(startIndex, endIndex);
            if (RELEASE_KEY.equals(versionType)) {
                builder.addDependencyReleaseVersion(artifactVersionlessKey, (String)currentEntry.getValue());
                continue;
            }
            if (!DEVELOPMENT_KEY.equals(versionType)) continue;
            builder.addDependencyDevelopmentVersion(artifactVersionlessKey, (String)currentEntry.getValue());
        }
    }
}

