/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractBackupPomsPhase;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ReleasePhase.class, hint="restore-backup-poms")
public class RestoreBackupPomsPhase
extends AbstractBackupPomsPhase {
    @Requirement
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        for (MavenProject project : reactorProjects) {
            this.restorePomBackup(releaseDescriptor, releaseEnvironment, project);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }

    protected void restorePomBackup(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, MavenProject project) throws ReleaseExecutionException, ReleaseFailureException {
        File pomBackup = this.getPomBackup(project);
        if (!pomBackup.exists()) {
            throw new ReleaseExecutionException("Cannot restore from a missing backup POM: " + pomBackup.getAbsolutePath());
        }
        try {
            EditScmResult result;
            ScmProvider provider;
            ScmRepository scmRepository;
            try {
                scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
                provider = this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
            }
            catch (ScmRepositoryException e) {
                throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
            }
            catch (NoSuchScmProviderException e) {
                throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
            }
            if ((releaseDescriptor.isScmUseEditMode() || provider.requiresEditMode()) && !(result = provider.edit(scmRepository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), project.getFile()))).isSuccess()) {
                throw new ReleaseScmCommandException("Unable to enable editing on the POM", (ScmResult)result);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred enabling edit mode: " + e.getMessage(), (Throwable)e);
        }
        try {
            FileUtils.copyFile((File)this.getPomBackup(project), (File)ReleaseUtil.getStandardPom(project));
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error restoring from backup POM: " + e.getMessage(), (Throwable)e);
        }
    }
}

