/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForBranchPhase
extends AbstractRewritePomsPhase {
    private Map<String, ScmTranslator> scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, String commonBasedir) throws ReleaseExecutionException {
        if (project.getScm() != null) {
            Element scmRoot = rootElement.getChild("scm", namespace);
            if (scmRoot != null) {
                releaseDescriptor.mapOriginalScmInfo(projectId, project.getScm());
                try {
                    this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, commonBasedir);
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            releaseDescriptor.mapOriginalScmInfo(projectId, null);
            MavenProject parent = project.getParent();
            if (parent != null) {
                String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                if (!releaseDescriptor.getOriginalScmInfo().containsKey(parentId)) {
                    scmRoot = new Element("scm");
                    scmRoot.addContent("\n  ");
                    try {
                        if (this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, commonBasedir)) {
                            rootElement.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
                        }
                    }
                    catch (IOException e) {
                        throw new ReleaseExecutionException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Element scmRoot, Namespace namespace, ScmRepository scmRepository, ReleaseResult relResult, String commonBasedir) throws IOException {
        ScmTranslator translator = this.scmTranslators.get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            String value2;
            String subDirectoryBranch;
            String rootUrl;
            Scm scm = project.getScm();
            String branchName = releaseDescriptor.getScmReleaseLabel();
            String branchBase = releaseDescriptor.getScmBranchBase();
            if (branchBase != null) {
                branchBase = "scm:svn:" + branchBase;
            }
            String workingDirectory = ReleaseUtil.isSymlink(project.getBasedir()) ? project.getBasedir().getCanonicalPath() : project.getBasedir().getAbsolutePath();
            int count = ReleaseUtil.getBaseWorkingDirectoryParentCount(commonBasedir, workingDirectory);
            if (scm.getConnection() != null) {
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getConnection());
                subDirectoryBranch = scm.getConnection().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if (!(value2 = translator.translateBranchUrl(scm.getConnection(), branchName + subDirectoryBranch, branchBase)).equals(scm.getConnection())) {
                    this.rewriteElement("connection", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getDeveloperConnection());
                subDirectoryBranch = scm.getDeveloperConnection().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if (!(value2 = translator.translateBranchUrl(scm.getDeveloperConnection(), branchName + subDirectoryBranch, branchBase)).equals(scm.getDeveloperConnection())) {
                    this.rewriteElement("developerConnection", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getUrl());
                subDirectoryBranch = scm.getUrl().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if (!(value2 = translator.translateBranchUrl(scm.getUrl(), branchName + subDirectoryBranch, releaseDescriptor.getScmBranchBase())).equals(scm.getUrl())) {
                    this.rewriteElement("url", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (branchName != null && (value = translator.resolveTag(branchName)) != null && !value.equals(scm.getTag())) {
                this.rewriteElement("tag", value, scmRoot, namespace);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    protected Map getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List reactorProjects, boolean simulate) {
        return releaseDescriptor.getOriginalVersions(reactorProjects);
    }

    protected Map getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getReleaseVersions();
    }

    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map resolvedSnapshotsMap) {
        Map versionsMap = (Map)resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return (String)versionsMap.get("rel");
        }
        return null;
    }
}

