/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.SiteMap;
import org.apache.maven.reporting.MavenReport;

public class SiteMojo
extends AbstractSiteRenderingMojo {
    protected File outputDirectory;
    private boolean generateReports;
    private boolean generateSitemap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List filteredReports = this.generateReports ? this.filterReports(this.reports) : Collections.EMPTY_LIST;
        try {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            Locale defaultLocale = (Locale)localesList.get(0);
            Locale.setDefault(defaultLocale);
            Iterator iterator = localesList.iterator();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                this.renderLocale(locale, filteredReports);
            }
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Error during page generation", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private void renderLocale(Locale locale, List reports) throws IOException, RendererException, MojoFailureException, MojoExecutionException {
        SiteRenderingContext context = this.createSiteRenderingContext(locale);
        context.setInputEncoding(this.getInputEncoding());
        context.setOutputEncoding(this.getOutputEncoding());
        Map documents = this.locateDocuments(context, reports, locale);
        File outputDir = this.getOutputDirectory(locale);
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            report.setReportOutputDirectory(outputDir);
        }
        this.siteRenderer.render(documents.values(), context, outputDir);
        if (this.generateSitemap) {
            this.getLog().info((CharSequence)"Generating Sitemap.");
            new SiteMap(this.getOutputEncoding(), this.i18n).generate(context.getDecoration(), this.generatedSiteDirectory, locale);
        }
        context.getSiteDirectories().clear();
        context.addSiteDirectory(this.generatedSiteDirectory);
        documents = this.siteRenderer.locateDocumentFiles(context);
        this.siteRenderer.render(documents.values(), context, outputDir);
    }

    private File getOutputDirectory(Locale locale) {
        File file = locale.getLanguage().equals(Locale.getDefault().getLanguage()) ? this.outputDirectory : new File(this.outputDirectory, locale.getLanguage());
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

